
/*****************************************************************************
//
//	File:			3dChannelServer.h
//
//	Description:	Class for managing graphics channels
//
//	Copyright 1997, Be Incorporated
//
// The 3dKit is a fully object-oriented library, going from low-level 3d
// engine to high-level 3d API. The whole system is decomposed in functional
// blocks, that can include both high-level and low-level API. To allow all
// those classes to communicate smoothly and efficiently, most of their datas
// and methods are public. That can introduce some confusion in the sense that
// reading the headers will not allow developer to differenciate API levels
// by their protection only. That's why some comments were added in the key
// classes of the 3dKit to help you recognize which API you should use
// depending of the level of usage you want.
*****************************************************************************/

#ifndef _3D_CHANNEL_SERVER_H
#define _3D_CHANNEL_SERVER_H

#ifndef _3D_UNIVERSE_H
#include <3dUniverse.h>
#endif
#ifndef _3D_CHANNEL_H
#include <3dChannel.h>
#endif

/* If you want to manage your own textures, you can use this */
extern B3dChannel * LoadTexture(const char *filename);

/**************************************
// B3dChannelServer
/*************************************/

class B3dChannelServer {
/*************************************
// LOW-LEVEL API                    */

	public:
	
					B3dChannelServer();
virtual  				~B3dChannelServer();

virtual	B3dChannel *	GetChannel(const char *name);

	protected:

		BList 		m_channels;
	
virtual	B3dChannel *	LoadChannel(const char *name)=0;
					
};

class B3dFileChannelServer : public B3dChannelServer {

	public:
	
					B3dFileChannelServer(const char *path=NULL);
virtual  				~B3dFileChannelServer();

		const char *	Path();
		void			SetPath(const char *path);

/*************************************
// LOW-LEVEL API                    */

	protected:

		char *		m_path;
	
virtual	B3dChannel *	LoadChannel(const char *name);
					
};

#endif
