/*****************************************************************************
//
//	File:			3dBitmap.h
//
//	Description:	Encapsulated Bitmap class
//
//	Copyright 1997, Be Incorporated
//
// The 3dKit is a fully object-oriented library, going from low-level 3d
// engine to high-level 3d API. The whole system is decomposed in functional
// blocks, that can include both high-level and low-level API. To allow all
// those classes to communicate smoothly and efficiently, most of their datas
// and methods are public. That can introduce some confusion in the sense that
// reading the headers will not allow developer to differenciate API levels
// by their protection only. That's why some comments were added in the key
// classes of the 3dKit to help you recognize which API you should use
// depending of the level of usage you want.
*****************************************************************************/

#ifndef _3D_BITMAP_H
#define _3D_BITMAP_H

#ifndef _3D_CHANNEL_H
#include <3dChannel.h>
#endif
#ifndef _BITMAP_H
#include <Bitmap.h>
#endif

/**************************************
// B3dBitmap.
/*************************************/

/*	The B3dBitmap calls is an encapsulation of a BBitmap as a B3dChannel.
	Suitable for most static texture mapping. */
class B3dBitmap : public B3dChannel {

/*************************************
// HIGH-LEVEL API                   */

 public:
			B3dBitmap(	const char *name,
						BBitmap *bitmap);
	/*	The constructor will crop the bitmap to the largest width
		and height which are powers of two. */
	
	virtual  ~B3dBitmap();
	/* The destructor is responsible for freeing the BBitmap. */
	
	BRect    Frame();
	/* The bounding rectangle of the bitmap (after cropping) */

/*************************************
// PRIVATE STUFF                    */

 private:
	BBitmap    *bitmap;
};

#endif








