/*****************************************************************************
//
//	File:			3dAmbientLight.h
//
//	Description:	Ambient light class
//
//	Copyright 1997, Be Incorporated
//
// The 3dKit is a fully object-oriented library, going from low-level 3d
// engine to high-level 3d API. The whole system is decomposed in functional
// blocks, that can include both high-level and low-level API. To allow all
// those classes to communicate smoothly and efficiently, most of their datas
// and methods are public. That can introduce some confusion in the sense that
// reading the headers will not allow developer to differenciate API levels
// by their protection only. That's why some comments were added in the key
// classes of the 3dKit to help you recognize which API you should use
// depending of the level of usage you want.
*****************************************************************************/

#ifndef _3D_AMBIENT_LIGHT_H
#define _3D_AMBIENT_LIGHT_H

#ifndef _3D_DEFS_H 
#include "3dDefs.h"
#endif
#ifndef _3D_LIGHT_H
#include "3dLight.h"
#endif

/**************************************
// B3dAmbientClass.
/*************************************/

class B3dAmbientLight : public B3dLight {

/*************************************
// HIGH-LEVEL API                   */

 public:
	B3dAmbientLight(char *name, B3dWorld *world, float power, RGBAColor *color);
	/* Create an ambient light named 'name' in the world 'world'. This will
	   project on every objects in the universe a non directional light, of
	   color 'color', scale by the coefficient power (1.0 to get just 'color').
	   Usualy, there is one and only one ambient light by universe.
	   */
	virtual ~B3dAmbientLight();
};

#endif
