/*****************************************************************************
//
//	File:			3dParallelLight.h
//
//	Description:	Representation of light with parallel rays.
//
//	Copyright 1997, Be Incorporated
//
// The 3dKit is a fully object-oriented library, going from low-level 3d
// engine to high-level 3d API. The whole system is decomposed in functional
// blocks, that can include both high-level and low-level API. To allow all
// those classes to communicate smoothly and efficiently, most of their datas
// and methods are public. That can introduce some confusion in the sense that
// reading the headers will not allow developer to differenciate API levels
// by their protection only. That's why some comments were added in the key
// classes of the 3dKit to help you recognize which API you should use
// depending of the level of usage you want.
*****************************************************************************/

#ifndef _3D_PARALLEL_LIGHT_H
#define _3D_PARALLEL_LIGHT_H

#ifndef _3D_DEFS_H 
#include "3dDefs.h"
#endif
#ifndef _3D_LIGHT_H
#include "3dLight.h"
#endif

/**************************************
// B3dParallelLight.
/*************************************/

class B3dParallelLight : public B3dLight {

/*************************************
// HIGH-LEVEL API                   */

 public:
	B3dParallelLight(	char		*name,
						B3dWorld	*world,
						float		power,
						RGBAColor	*color,
						RGBAColor   *specularColor,
						B3dVector	*direction);
	/* create a light at infinite distance, named 'name', in the
	   world 'world', that will light things from the direction
	   'direction'. The color of the light will be 'color' multiplied
	   by the factor 'power' (standard value of 1.0). You can used
	   multiple parallel lights.  'specularColor' is the specular
	   component of the light (the highlight).
	   */
	virtual ~B3dParallelLight();

	RGBAColor m_specularColor;
};

#endif

