/*****************************************************************************
//
//	File:			3dLook.h
//
//	Description:	Generic class describing the appearance of objects.
//
//	Copyright 1997, Be Incorporated
//
// The 3dKit is a fully object-oriented library, going from low-level 3d
// engine to high-level 3d API. The whole system is decomposed in functional
// blocks, that can include both high-level and low-level API. To allow all
// those classes to communicate smoothly and efficiently, most of their datas
// and methods are public. That can introduce some confusion in the sense that
// reading the headers will not allow developer to differenciate API levels
// by their protection only. That's why some comments were added in the key
// classes of the 3dKit to help you recognize which API you should use
// depending of the level of usage you want.
*****************************************************************************/

#ifndef _3D_LOOK_H
#define _3D_LOOK_H

#include <InterfaceDefs.h>

#include "3dModel.h"
#include <3dChannel.h>
#include "RGBAColor.h"
#include "3dMaterial.h"
#include "3dPointLook.h"

/**************************************
// HIGH-LEVEL API
/*************************************/

extern RGBAColor RGBADefaultColor;
/* default white color */

/**************************************
// LOW-LEVEL API
/*************************************/

struct B3dLookUnion
{
	B3dMaterial	face;
	B3dPointLook	point;
};

class B3dModel;
class B3dLens;
class B3dRenderer;
class B3dLensPoint;
class B3dLightProc;

/* descriptor of one line-point definition (Point, Norm, Lighting, Descriptor) */
/* N_transformed is there in case certain renderers need it */
struct PNLD {
	B3dLensPoint	*P;
	B3dVector		*N;
	B3dVector		*N_transformed;
	B3dLightInfo	*L;
	B3dLookUnion	*D;
};

/* Hook used for interpolation of pnld parameters during cliping */
typedef void (*inter_hook)(PNLD *p1, float ref1, PNLD *p2, float ref2, PNLD *new_p);

/**************************************
// B3dLook.
/*************************************/

class B3dLook {

/*************************************
// HIGH-LEVEL API                   */

	public:
	
	inline const char	*Name();
	void				SetName(const char *new_name);
    /* return and set the look name */

/*************************************
// LOW-LEVEL API                    */

					B3dLook(const char *name, B3dModel *model);
	virtual			~B3dLook();
	virtual	void		Draw(	uint32			clip_flag,
							B3dMatrix			*rotation,
							B3dVector			*translation,
							B3dLens			*lens,
							B3dRenderer		*renderer,
							B3dLightProc		*lightProc,
							B3dSharedState	*buf);

	int32			referenceCount;
	B3dModel			*model;

/*************************************
// PRIVATE STUFF                    */

 private:
 
	char				*name;
};

/**************************************
// INLINE FUNCTION DEFINITIONS
/*************************************/

const char *B3dLook::Name() {
	return name;
}

#endif
