/*****************************************************************************
//
//	File:			3dFaceModel.h
//
//	Description:	3d model descriptor for 3d face object.
//
//	Copyright 1997, Be Incorporated
//
*****************************************************************************/

#ifndef _3D_FACE_MODEL_H
#define _3D_FACE_MODEL_H

#ifndef _3D_MODEL_H
#include "3dModel.h"
#endif

/* Model types */
enum {
	B_FACE_MODEL		= 0x0000,
	B_SMOOTH_MODEL	= 0x0001,
	B_ADVANCED_MODEL	= 0x0002
};

typedef struct {
	short    points[3];
	short    normal;
} B3dFaceDesc;

typedef struct {
	short    normals[3];
} B3dAdvancedFaceDesc;

typedef struct {
	int32				modelType;

	int32				pointCount;
	int32				normalCount;
	int32				faceCount;

	B3dVector				*points;
	B3dVector				*normals;
	B3dFaceDesc			*faces;
	B3dAdvancedFaceDesc	*advancedFaces;

	void					*extension;
} B3dFaceModelDesc;

class B3dFaceModel : public B3dModel
{

	public:
	
		ushort						m_modelLevel;
		BArray<B3dVector>				m_faceNorms;
		BArray<B3dFaceDesc>			m_faces;
		BArray<B3dAdvancedFaceDesc>		m_advancedFaces;
		void							*m_extension;
	
									B3dFaceModel(	B3dFaceModelDesc *desc, 
												uint32 creationFlags = 0);
virtual 								~B3dFaceModel();
virtual	void *						Sort(		B3dLensImage *lensImage, 
												uint32 status,
												B3dSharedState *buf);

	private:
		int32    crc_alea;
		void							KiltSort(	uint16 *i0, uint16 *i1, 
											float *z0, float *z1);
};

#endif

 







