/*****************************************************************************
//
//	File:			3dCinepakChannel.h
//
//	Description:	Cinepak movie player channel.
//
//	Copyright 1997, Be Incorporated
//
// The 3dKit is a fully object-oriented library, going from low-level 3d
// engine to high-level 3d API. The whole system is decomposed in functional
// blocks, that can include both high-level and low-level API. To allow all
// those classes to communicate smoothly and efficiently, most of their datas
// and methods are public. That can introduce some confusion in the sense that
// reading the headers will not allow developer to differenciate API levels
// by their protection only. That's why some comments were added in the key
// classes of the 3dKit to help you recognize which API you should use
// depending of the level of usage you want.
*****************************************************************************/

#ifndef _3D_CINEPAK_CHANNEL_H
#define _3D_CINEPAK_CHANNEL_H

#ifndef _FILE_H
#include <File.h>
#endif
#ifndef _3D_CHANNEL_H
#include <3dChannel.h>
#endif
#ifndef _BITMAP_H
#include <Bitmap.h>
#endif
#ifndef _3D_UNIVERSE_H
#include <3dUniverse.h>
#endif

class QTPlayer;

/**************************************
// B3dCinepakChannel.
/*************************************/

class B3dCinepakChannel : public B3dChannel {
	friend long cinepak_player_thread(void *data);
	friend void cinepak_channel_hook(void *data, B3dTimeBase *base);

/*************************************
// HIGH-LEVEL API                   */

 public:
	B3dCinepakChannel(const char *_name, B3dUniverse *uni, entry_ref *tref);
		/*	This name of the channel should be specified.  This is the name
			that will be used to designated the channel when exporting objects
			(to the native format or to others) and is also thus the name that
			will be asked for from the channel server when importing objects.
			A Cinepak channel is not static and so need to be synchronise with
			the flow of time. That why a Cinepak channel can only be shared
			inside a specific universe, uni in this case. */
	virtual ~B3dCinepakChannel();

/*************************************
// PRIVATE STUFF                    */

 private:
	bool        first, death_flag;
	void        *base;
	int32       size, row_byte, offset;
	int32       line_count;
	int32       mTime;
	int32       token;
	sem_id      read_sem, write_sem;
	BBitmap     *bitmap;
	QTPlayer    *mPlayer;
	thread_id   player;
	B3dUniverse *uni;
};

#endif













