/*****************************************************************************
//
//	File:			3dBody.h
//
//	Description:	Class to create instance of generic 3d object (Thing).
//
//	Copyright 1997, Be Incorporated
//
// The 3dKit is a fully object-oriented library, going from low-level 3d
// engine to high-level 3d API. The whole system is decomposed in functional
// blocks, that can include both high-level and low-level API. To allow all
// those classes to communicate smoothly and efficiently, most of their datas
// and methods are public. That can introduce some confusion in the sense that
// reading the headers will not allow developer to differenciate API levels
// by their protection only. That's why some comments were added in the key
// classes of the 3dKit to help you recognize which API you should use
// depending of the level of usage you want.
*****************************************************************************/

#ifndef _3D_BODY_H
#define _3D_BODY_H

#include <unistd.h>

#ifndef _3D_THING_H 
#include "3dThing.h"
#endif
#ifndef _3D_MODEL_H 
#include "3dModel.h"
#endif
#ifndef _3D_LOOK_H 
#include "3dLook.h"
#endif

/**************************************
// B3dBody.
/*************************************/

class B3dBody : public B3dThing {

/*************************************
// LOW-LEVEL API                    */

 public:
						B3dBody(char *name, B3dWorld *world, uint32 status = NULL);
						B3dBody(B3dBody *body, char *name, uint32 clone_flag);
	virtual				~B3dBody();
	void				SetLook(B3dLook *new_look);
	virtual B3dThing	*Clone(char *name = 0L, uint32 clone_flag = 0);
	virtual void		Draw(	B3dLighter		*lighter,
								B3dLens			*projector,
								B3dRenderer		*renderer,
								B3dVector		*offset0,
								B3dMatrix		*rot,
								B3dSharedState	*buf);
	B3dLook				*look;
};

#endif











