/*
 * socket_private.h
 * Copyright (c) 1997 Be, Inc.	All Rights Reserved 
 *
 * private socket calls
 * these should be properly underbarred
 *
 */
#ifndef _SOCKET_PRIVATE_H
#define _SOCKET_PRIVATE_H

#include <BeBuild.h>

#include <cplusplus.h>

EXTERNC _IMPEXP_NET 
int _socket_interrupt(int fd);

EXTERNC _IMPEXP_NET 
int _b_pre_accept(int sd, struct sockaddr *addr, int *addrlen);

EXTERNC _IMPEXP_NET 
int _netstat(int sd, char **bufp, int flags);

EXTERNC _IMPEXP_NET 
int _b_post_accept(struct sockaddr *localaddr, int laddrlen,
						  struct sockaddr *remoteaddr, int *raddrlen);

EXTERNC _IMPEXP_NET 
int _socket_signals;

#if __cplusplus
#include <transact.h>

EXTERNC _IMPEXP_NET
_Transacter *_any_socket_get_trans(int sd);
#endif /* __cplusplus */

EXTERNC _IMPEXP_NET
int _any_socket_open(const char *server_name, long proto_code);

#define b_post_accept _b_post_accept
#define b_pre_accept _b_pre_accept

#endif /* _SOCKET_PRIVATE_H */
