/* Copyright (C) 1991, 1992, 1993, 1994, 1995 Free Software Foundation, Inc.

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Library General Public License as
published by the Free Software Foundation; either version 2 of the
License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Library General Public License for more details.

You should have received a copy of the GNU Library General Public
License along with this library; see the file COPYING.LIB.  If
not, write to the Free Software Foundation, Inc., 675 Mass Ave,
Cambridge, MA 02139, USA.  */

#ifndef	_MALLOC_INTERNAL
#define _MALLOC_INTERNAL
#include "malloc.h"
#endif


static void *
gnu_memalign (size_t alignment, size_t size, malloc_state *ms,
			  malloc_funcs *mf)
{
  void * result;
  unsigned long int adj;

  size = ((size + alignment - 1) / alignment) * alignment;

  result = _malloc_internal (size, ms, mf);
  if (result == NULL)
    return NULL;
  adj = (unsigned long int) ((unsigned long int) ((char *) result -
						  (char *) NULL)) % alignment;
  if (adj != 0)
    {
      struct alignlist *l;
      for (l = ms->_aligned_blocks; l != NULL; l = l->next)
	if (l->aligned == NULL)
	  /* This slot is free.  Use it.  */
	  break;
      if (l == NULL)
	{
	  l = (struct alignlist *) _malloc_internal (sizeof (struct alignlist), ms, mf);
	  if (l == NULL)
	    {
	      _free (result, ms, mf);
	      return NULL;
	    }
	  l->next = ms->_aligned_blocks;
	  ms->_aligned_blocks = l;
	}
      l->exact = result;
      result = l->aligned = (char *) result + alignment - adj;
    }

  return result;
}



void *
_memalign (size_t alignment, size_t size, malloc_state *ms, malloc_funcs *mf)
{
  void * ret;
  
  if (mf->memalign_hook)
    return mf->memalign_hook (alignment, size, ms, mf);

  _m_acquire_sem(ms);
  ret = gnu_memalign(alignment, size, ms, mf);
  _m_release_sem(ms);

  return ret;
}
