/* BTimedEventQueue */
/* a queue for holding media events */
/* also includes BBEventIterator - a helper class for */
/* iterating over specified events in a BBTimedEventQueue */

#ifndef _TIMED_EVENT_QUEUE_H
#define _TIMED_EVENT_QUEUE_H

#include <MediaDefs.h>

struct _event_queue_imp;


struct timed_event {
					timed_event();
					timed_event(bigtime_t inTime, int32 inType);
					timed_event(bigtime_t inTime, int32 inType,
						void *inPointer, uint32 inCleanup);
					timed_event(
						bigtime_t inTime, int32 inType,
						void *inPointer, uint32 inCleanup,
						int32 inData, int64 inBigdata,
						char *inUserData);
					
	bigtime_t		event_time;
	int32			type;
	void *			pointer;
	uint32			cleanup;
	int32			data;
	int64			bigdata;
	char			user_data[64];
	uint32			_reserved[8];
};

bool operator==(const timed_event & a, const timed_event & b);
bool operator!=(const timed_event & a, const timed_event & b);
bool operator<(const timed_event & a, const timed_event & b);
bool operator>(const timed_event & a, const timed_event &b);


class BTimedEventQueue {
	public:

		enum event_type {
			B_NO_EVENT = -1,		// never push this type! it will fail
			B_ANY_EVENT = 0,		// never push this type! it will fail
			B_START,
			B_STOP,
			B_SEEK,
			B_WARP,
			B_TIMER,
			B_HANDLE_BUFFER,
			B_DATA_STATUS,
			B_HARDWARE,
			/* user defined events above this value */
			B_USER_EVENT = 0x4000
		};

		enum cleanup_flag {
			B_NO_CLEANUP = 0,
			B_RECYCLE_BUFFER,		// recycle buffers handled by BTimedEventQueue
			B_USER_CLEANUP = 0x4000	// others go to the cleanup func
		};

		enum time_direction {
			B_ALWAYS = -1,
			B_BEFORE_TIME = 0,
			B_AT_TIME,
			B_AFTER_TIME
		};


		void * operator new(size_t s);
		void operator delete(void * p, size_t s);
		
							BTimedEventQueue();
		virtual				~BTimedEventQueue();
		
		status_t			AddEvent(const timed_event &event);
		status_t			RemoveEvent(const timed_event *event);
		status_t  			RemoveFirstEvent(timed_event * out_event = NULL);
		
		bool				HasEvents() const;

		/* Accessors */
		const timed_event *	FirstEvent() const;
		bigtime_t			FirstEventTime() const;
		const timed_event *	LastEvent() const;
		bigtime_t			LastEventTime() const;

		const timed_event *	FindFirstMatch(
								bigtime_t eventTime,
								time_direction direction,
								bool inclusive = true,
								int32 eventType = B_ANY_EVENT);

		
		/* queue manipulation */
		/* call DoForEach to perform a function on each event in the */
		/* queue.  Return an appropriate status defining an action to take */
		/* for that event.  DoForEach is an atomic operation guaranteeing the */
		/* consistency of the queue during the call.  Any actions occur after the */
		/* iteration has completed */
		enum queue_action {
			B_DONE = -1,
			B_NO_ACTION = 0,
			B_REMOVE_EVENT,
			B_RESORT_QUEUE
		};
		typedef queue_action (*for_each_hook)(timed_event *event, void *context);
		
		status_t			DoForEach(
								for_each_hook hook,
								void *context,
								bigtime_t eventTime = 0,
								time_direction direction = B_ALWAYS,
								bool inclusive = true,
								int32 eventType = B_ANY_EVENT);
		
		
		/* flushing events */
		typedef void (*cleanup_hook)(const timed_event *event, void * context);	
		void				SetCleanupHook(cleanup_hook hook, void *context);
		status_t			FlushEvents(
								bigtime_t eventTime,
								time_direction direction,
								bool inclusive = true,
								int32 eventType = B_ANY_EVENT);
				
		
	private:
//		friend BEventIterator;
							BTimedEventQueue(					//unimplemented
								const BTimedEventQueue & other);
							BTimedEventQueue &operator =(		//unimplemented
								const BTimedEventQueue & other);


		/* hide actual queue implementation */
		_event_queue_imp *	fImp;

		/* Mmmh, stuffing! */
		virtual	status_t 	_Reserved_BTimedEventQueue_0(void *, ...);
		virtual	status_t 	_Reserved_BTimedEventQueue_1(void *, ...);
		virtual	status_t 	_Reserved_BTimedEventQueue_2(void *, ...);
		virtual	status_t 	_Reserved_BTimedEventQueue_3(void *, ...);
		virtual	status_t 	_Reserved_BTimedEventQueue_4(void *, ...);
		virtual	status_t 	_Reserved_BTimedEventQueue_5(void *, ...);
		virtual	status_t 	_Reserved_BTimedEventQueue_6(void *, ...);
		virtual	status_t 	_Reserved_BTimedEventQueue_7(void *, ...);
		virtual	status_t 	_Reserved_BTimedEventQueue_8(void *, ...);
		virtual	status_t 	_Reserved_BTimedEventQueue_9(void *, ...);
		virtual	status_t 	_Reserved_BTimedEventQueue_10(void *, ...);
		virtual	status_t 	_Reserved_BTimedEventQueue_11(void *, ...);
		virtual	status_t 	_Reserved_BTimedEventQueue_12(void *, ...);
		virtual	status_t 	_Reserved_BTimedEventQueue_13(void *, ...);
		virtual	status_t 	_Reserved_BTimedEventQueue_14(void *, ...);
		virtual	status_t 	_Reserved_BTimedEventQueue_15(void *, ...);
		virtual	status_t 	_Reserved_BTimedEventQueue_16(void *, ...);
		virtual	status_t 	_Reserved_BTimedEventQueue_17(void *, ...);
		virtual	status_t 	_Reserved_BTimedEventQueue_18(void *, ...);
		virtual	status_t 	_Reserved_BTimedEventQueue_19(void *, ...);
		virtual	status_t 	_Reserved_BTimedEventQueue_20(void *, ...);
		virtual	status_t 	_Reserved_BTimedEventQueue_21(void *, ...);
		virtual	status_t 	_Reserved_BTimedEventQueue_22(void *, ...);
		virtual	status_t 	_Reserved_BTimedEventQueue_23(void *, ...);

		uint32 				_reserved_timed_event_queue_[8];
};

#endif
