/*****************************************************************************
//
//	File:			3dRadialLens.h
//
//	Description:	Standard planar perspective.
//
//	Copyright 1997, Be Incorporated
//
// ******** 3dKit ARCHITECTURE NOTE :
// The 3dKit is a fully object-oriented library, going from low-level 3d
// engine to high-level 3d API. The whole system is decomposed in functional
// blocks, that can include both high-level and low-level API. To allow all
// those classes to communicate smoothly and efficiently, most of their datas
// and methods are public. That can introduce some confusion in the sense that
// reading the headers will not allow developer to differenciate API levels
// by their protection only. That's why some comments were added in the key
// classes of the 3dKit to help you recognize which API you should use
// depending of the level of usage you want.
//***************************************************************************/

#ifndef _3D_RADIAL_LENS_H
#define _3D_RADIAL_LENS_H

#ifndef _3D_LENS_H
#include "3dLens.h"
#endif

class B3dWorldSort;
class B3dRadialLens;


/**************************************
// HIGH-LEVEL API
/*************************************/

class B3dRadialOptions : public B3dLensOptions {
	friend class B3dRadialLens;
	
 public:
	float    zoom;
	/* This struct is used to get and set the current opening of the lens.
	   */
	
/**************************************
// PRIVATE STUFF
/*************************************/

	void     CheckOptions();
 private:
	float    OffsetH;
	float    OffsetV;
	float    XZMin;
	float    XZMax;
	float    YZMin;
	float    YZMax;
	float    NormXZMin;
	float    NormXZMax;
	float    NormYZMin;
	float    NormYZMax;
}; 

enum {
	B_CLIP_HMIN = 0x0001,
	B_CLIP_HMAX = 0x0002,
	B_CLIP_VMIN = 0x0004,
	B_CLIP_VMAX = 0x0008,
	B_CLIP_ZMIN = 0x0010
};

class B3dRadialPoint : public B3dLensPoint {
 public:
	long     visible;
};

/**************************************
// B3dRadialLens.
/*************************************/

class B3dRadialLens : public B3dLens {

/*************************************
// HIGH-LEVEL API                   */

	public:

virtual	void			GetOptions(void **options);
	/* Return a pointer to the current struct used to store the specific lens
	   parameters. Use the pointer *options to read/modify the 'zoom' parameter
	   of the lens (controling the opening of the view). */
virtual	void			SetOptions();
	/* Call this function after any modification of the zoom parameter. */

virtual	B3dVector		Screen2Camera(B3dVector vectorInScreenSpace);
virtual	B3dVector		Camera2Screen(B3dVector vectorInCameraSpace);
virtual	B3dVector		Pixel2Screen(BPoint pixel, float z);
virtual	BPoint		Screen2Pixel(B3dVector vectorInScreenSpace);
	
/*************************************
// LOW-LEVEL API                    */

	B3dRadialLens();
	virtual ~B3dRadialLens();

	virtual bool See(B3dModel   *model,
					 B3dMatrix  *rotation,
					 B3dVector  *translation,
					 long       status,
					 B3dLensImage *lensImage);
	virtual void See(B3dCamera    *camera,
					 B3dMatrix    *rotation,
					 float        trans_z);
	virtual long CheckSteric(float radius, B3dMatrix *rotation, B3dVector *translation);
	virtual void CalcAxis(B3dVector *pointOnScreen, B3dVector *axis);
	virtual void Clip(render_desc *desc, PNLD *array);
	virtual void GetBuffers(B3dLensPoint *array[8]);
	
/*************************************
// PRIVATE STUFF                    */

 private:	
	int              ClipCount;
	long             maxVector;
	long             maxPt;
	PNLD             *ClipPnld[7];
	PNLD             *curFreePnld;
	B3dVector        *lensVectors;
	B3dLensPoint     *lensPoints;
	B3dRadialPoint   my_point[8];
	B3dRadialOptions Options;
	
	void         CheckListSize(long nbVector, long nbPt);
	void         ClipPlan(float x, float y, float z, inter_hook inter);
	void         CalculeNewPt(PNLD *pnld1, float rel1,
							  PNLD *pnld2, float rel2,
							  PNLD *new_pnld, inter_hook inter);
};

#endif

















