/* ++++++++++
	FILE:	3dFaceEditor.h
	REVS:	$Revision: 1.4 $
	NAME:	pierre
	DATE:	Mon Apr 28 18:02:44 PDT 1997
	Copyright (c) 1997 by Be Incorporated.  All Rights Reserved.
+++++ */

#ifndef _3D_FACE_EDITOR_H
#define _3D_FACE_EDITOR_H

#ifndef _3D_FACE_H
#include <3dFace.h>
#endif
#ifndef _3D_FACE_MODEL_H
#include <3dFaceModel.h>
#endif
#ifndef _3D_FACE_LOOK_H
#include <3dFaceLook.h>
#endif
#ifndef _FILE_H
#include <File.h>
#endif

enum {
	B_ALL_FACES = -1
};

/* enum of the different types of file we can read */
enum {
	B_GH_TYPE      /* private Be format, very simple, just points and triangles */
};

class B3dFaceEditor {
 public:
	B3dFaceEditor(char *filename, int32 type);
	B3dFaceEditor(B3dFace *faces);
	~B3dFaceEditor();

	void      SetFaceColor(RGBAColor *color, int face_index = -1);
	void      SetPointColor(RGBAColor *color, int point_index, int face_index = -1);
	void      SetFaceMapping(int face_index, MapLookP *pt_refs, B3dChannel *texture);
	void      SetFaceMirror(int face_index, B3dChannel *mirror, float zoom_factor);
	B3dFace   *CurrentFace(char *name, B3dUniverse *uni);
 private:
	int             point_count;
	int             face_count;
	uint8           *type_table;
	B3dVector       *point_list;
	B3dVector       *norm_list;
	B3dFaceDesc     *face_list;
	B3dFaceModel    *model;	
	union look_edit *look_table;

	void      InitLookTables();
};

#endif







