/*****************************************************************************
//
//	File:			3dChannel.h
//
//	Description:	Graphic Channel class
//
//	Copyright 1997, Be Incorporated
//
// The 3dKit is a fully object-oriented library, going from low-level 3d
// engine to high-level 3d API. The whole system is decomposed in functional
// blocks, that can include both high-level and low-level API. To allow all
// those classes to communicate smoothly and efficiently, most of their datas
// and methods are public. That can introduce some confusion in the sense that
// reading the headers will not allow developer to differenciate API levels
// by their protection only. That's why some comments were added in the key
// classes of the 3dKit to help you recognize which API you should use
// depending of the level of usage you want.
//***************************************************************************/

#ifndef _3D_CHANNEL_H
#define _3D_CHANNEL_H

#ifndef _3D_UNIVERSE_H
#include <3dUniverse.h>
#endif

/**************************************
// B3dChannel.
/*************************************/

class B3dChannel {
/*************************************
// LOW-LEVEL API                    */

	public:
	
		const char *	Name();
		void			SetName(const char *name);

		void          *bits;
		/* base pointer of a RGB_32_BITS buffer */

		uint32        size_h;
		uint32        size_v;
		/*	This designates the width and height of the image at "bits".  Note that
			these are not the values themselves, but rather the number of times a
			one should be shifted left to obtain the size.  Thus, the actual width
			is (1<<size_h), and the actual height (1<<size_v).  Yes, this means
			textures must be powers of 2 in width and height. */
		
					B3dChannel(const char *_name);
		/*	This name of the channel should be specified.  This is the name
			that will be used to designated the channel when exporting objects
			(to the native format or to others) and is also thus the name that
			will be asked for from the channel server when importing objects. */

virtual  				~B3dChannel();

	private:
	
		char			*m_name;
};

#endif













