/******************************************************************************
//
//	File:		 3dmovApp.h
//
//	Description: Demo application using the 3d Kit.
//
//	Copyright 1996, Be Incorporated
//
//****************************************************************************/

#ifndef _3D_MOV_APP_H
#define _3D_MOV_APP_H

#ifndef _APPLICATION_H
#include <Application.h>
#endif
#ifndef _3D_MOV_WINDOW_H
#include "3dmovWindow.h"
#endif
#ifndef _POP_UP_MENU_H
#include <PopUpMenu.h>
#endif
#ifndef _MENU_ITEM_H
#include <MenuItem.h>
#endif
#ifndef _BITMAP_H
#include <Bitmap.h>
#endif
#ifndef _FILE_H
#include <File.h>
#endif
#ifndef _3D_FACE_H
#include <3dFace.h>
#endif
#ifndef _3D_BITMAP_H
#include <3dBitmap.h>
#endif
#ifndef _3D_UINVERSE_H
#include <3dUniverse.h>
#endif

#include <Entry.h>

enum {
	FIRST_WINDOW = 1000,
	SECOND_WINDOW,
	THIRD_WINDOW,
	FOURTH_WINDOW,
	PAUSE_WINDOWS
};

extern B3dBitmap *default_texture;
extern B3dBitmap *default_texture2;

class Z3dApplication : public BApplication {
public:
	int			 window_count;
	bool		 Pause;
	bool         channel_locks[13];
	dev_t        channel_dev[13];
	ino_t        channel_ino[13];
	sem_id       window_sem;
	Z3dWindow	 *myWindow[4];
	B3dChannel   *channels[13];
	B3dUniverse  *shared_uni;
	
	Z3dApplication();
	~Z3dApplication();
	virtual void	AboutRequested(void);
	virtual void	MessageReceived(BMessage* msg);
	void			ActiveWindow(long index, long state);
	void			SelectChannel(entry_ref    *tref,
								  B3dFaceBody  *obj,
								  selection_id touch,
								  int          index);
	void            ClearChannel(int index);
};

#endif















