#ifndef _3D_SUPPORT_H
#define _3D_SUPPORT_H

#define assert(a) \
if (!(a)) { \
	printf("ASSERTION FAILED: %s(%d)\n",__FILE__,__LINE__); \
	debugger("assertion failed"); \
};

extern uint32 set_has_bits(uint32 rid);

/* Some useful macros to manipulate bitmaps */
#define BMALLOC(num) \
  calloc((num+7)>>3,1)
#define BMTST(bm, num)  \
  (((char *) (bm))[(num) >> 3] & (0x80 >> ((num) & 0x07)))
#define BMSET(bm, num)  \
  (((char *) (bm))[(num) >> 3] |= (0x80 >> ((num) & 0x07)))
#define BMCLR(bm, num)  \
  (((char *) (bm))[(num) >> 3] &= ~(0x80 >> ((num) & 0x07))) 

struct Bitmap
{
		void *	bm;

			Bitmap(int32 numBits)
				{ bm = BMALLOC(numBits); };
            ~Bitmap()
				{ free(bm); };
inline	bool		test(int32 num)
				{ return BMTST(bm,num); };
inline	void		set(int32 num)
				{ BMSET(bm,num); };
inline	void		setExtent(int32 start, int32 len)
				{ for (int32 q=0;q<len;q++) BMSET(bm,start+q); };
inline	void		clear(int32 num)
				{ BMCLR(bm,num); };
};

template <class t>
class BArray {

	private:

		t		*items;
		int		numItems;
		int		numSlots;
		int		blockSize;

inline	void		AssertSize(int size)
{
	if (size > numSlots) {
		numSlots = ((size+blockSize-1)/blockSize) * blockSize;
		items = (t*)realloc(items,numSlots*sizeof(t));
	};
};

	public:

inline			BArray(int _blockSize=256)
{
	blockSize = _blockSize;
	numItems = numSlots = 0;
	items = NULL;
};

inline			BArray(BArray<t> &copyFrom)
{
	blockSize = copyFrom.blockSize;
	numSlots = 0;
	items = NULL;
	AssertSize(copyFrom.numSlots);
	numItems = copyFrom.numItems;
	memcpy(items,copyFrom.items,numItems*sizeof(t));
};

inline			~BArray()
{
	if (items)
		free(items);
};

inline	t*		Items()
{
	return items;
};

inline	void		SetList(t* newList, int32 listSize)
{
	if (items)
		free(items);
	items = newList;
	numSlots = listSize;
	numItems = listSize;
};

inline	void		SetSlots(int32 slots)
{
	if (numSlots != slots) {
		numSlots = slots;
		if (numItems > numSlots)
			numItems = numSlots;
		items = (t*)realloc(items,numSlots*sizeof(t));
	};
};

inline	void		SetItems(int32 count)
{
	AssertSize(count);
	numItems = count;
};

inline	void		Trim()
{
	SetSlots(numItems);
};

inline	int32	CountItems()
{ return numItems; };

/*
inline	bool		IsMember(t &theT)
{
	for (int32 i=0;i<numItems;i++)
		if (theT == items[i]) return true;
	return false;
};
*/

inline	void		RemoveItems(int32 index, int32 len)
{
	memmove(items+index,items+index+len,sizeof(t)*(numItems-index-len));
	numItems-=len;
};

inline	void		RemoveItem(int32 index)
{
	RemoveItems(index,1);
};

inline	int32	AddArray(BArray<t> *a)
{
	AssertSize(numItems + a->numItems);
	memcpy(items+numItems,a->items,a->numItems*sizeof(t));
	numItems = numItems + a->numItems;
	return a->numItems;
};

inline	int32	AddItem(const t &theT)
{
	AssertSize(numItems+1);
	items[numItems] = theT;
	numItems++;
	return numItems-1;
};

inline	void		MakeEmpty()
{
	numSlots = 0;
	numItems = 0;
	if (items!=NULL) {
		free(items);
		items = NULL;
	};
};

inline	t&		ItemAt(int index)
				{ return items[index]; };

inline	t&		operator[](int index)
				{ return items[index]; };
};

/*

inline BArray::BArray(int _blockSize)
{
	blockSize = _blockSize;
	numItems = numSlots = 0;
	items = NULL;
};

inline BArray::BArray(BArray<t> &copyFrom)
{
	blockSize = c.blockSize;
	numSlots = 0;
	items = NULL;
	AssertSize(c.numSlots);
	numItems = c.numItems;
	memcpy(items,c.items,numItems*sizeof(t));
};

inline BArray::~BArray()
{
	if (items)
		free(items);
};

inline void BArray::SetCount(int32 count)
{
	numItems = count;
};

inline void BArray::SetSlots(int32 slots)
{
	if (numSlots != slots) {
		numSlots = slots;
		if (numItems > numSlots)
			numItems = numSlots;
		items = realloc(items,numSlots*sizeof(t));
	};
};

inline void BArray::Trim()
{
	SetSlots(numItems);
};

inline int32 BArray::CountItems()
{ return numItems; };

inline bool BArray::IsMember(t &theT)
{
	for (int32 i=0;i<numItems;i++)
		if (theT == items[i]) return true;
	return false;
};

inline void BArray::RemoveItem(int32 index)
{
	memmove(items+index,items+index+1,sizeof(t)*(numItems-index-1));
	numItems--;
};

inline int32 BArray::AddArray(BArray<t> *a)
{
	AssertSize(numItems + a->numItems);
	memcpy(items+numItems,a->items,a->numItems*sizeof(t));
	numItems = numItems + a->numItems;
	return a->numItems;
};

inline int32 BArray::AddItem(t &theT)
{
	AssertSize(numItems+1);
	items[numItems] = theT;
	numItems++;
	return numItems-1;
};

inline void BArray::MakeEmpty()
{
	numSlots = 0;
	numItems = 0;
	if (items!=NULL) {
		free(items);
		items = NULL;
	};
};

*/

#endif
