/*****************************************************************************
//
//	File:		    3dSpinModel.h
//
//	Description:	Model associated with Spin object.
//
//	Copyright 1997, Be Incorporated
//
// The 3dKit is a fully object-oriented library, going from low-level 3d
// engine to high-level 3d API. The whole system is decomposed in functional
// blocks, that can include both high-level and low-level API. To allow all
// those classes to communicate smoothly and efficiently, most of their datas
// and methods are public. That can introduce some confusion in the sense that
// reading the headers will not allow developer to differenciate API levels
// by their protection only. That's why some comments were added in the key
// classes of the 3dKit to help you recognize which API you should use
// depending of the level of usage you want.
//***************************************************************************/

#ifndef _3D_SPIN_MODEL_H
#define _3D_SPIN_MODEL_H

#ifndef _3D_FACE_MODEL_H
#include "3dFaceModel.h"
#endif
#ifndef _2D_VECTOR_H
#include "2dVector.h"
#endif

/**************************************
// B3dSpinModel.
/*************************************/

class B3dSpinModel : public B3dFaceModel {
	friend class B3dSpin;
/*************************************
// LOW-LEVEL API                    */

 public:
	B3dSpinModel(B2dVector *shape, int32 shapeCount, int32 radiusCount);
	virtual ~B3dSpinModel();
	virtual void *Sort(B3dLensImage *lensImage, uint32 status, B3dSharedState *buf);
	
/*************************************
// PRIVATE STUFF                    */

 private:
	float      *divider;
	int32       radiusCount;
	int32       bandCount;
	int32       bottom, top;
	
	static B3dFaceModelDesc *BuildModel(B2dVector *shape, int32 shapeCount, int32 radiusCount);
};

#endif

 












