/*****************************************************************************
//
//	File:			3dLight.h
//
//	Description:	Generic class for light object.
//
//	Copyright 1997, Be Incorporated
//
// The 3dKit is a fully object-oriented library, going from low-level 3d
// engine to high-level 3d API. The whole system is decomposed in functional
// blocks, that can include both high-level and low-level API. To allow all
// those classes to communicate smoothly and efficiently, most of their datas
// and methods are public. That can introduce some confusion in the sense that
// reading the headers will not allow developer to differenciate API levels
// by their protection only. That's why some comments were added in the key
// classes of the 3dKit to help you recognize which API you should use
// depending of the level of usage you want.
//***************************************************************************/

#ifndef _3D_LIGHT_H
#define _3D_LIGHT_H

#ifndef _3D_DEFS_H 
#include "3dDefs.h"
#endif
#ifndef _3D_THING_H
#include "3dThing.h"
#endif

/**************************************
// PRIVATE STUFF
/*************************************/

enum {
	B_AMBIENT_LIGHT = 0,
	B_PARALLEL_LIGHT = 1,
	B_RADIAL_LIGHT =   2
};

/**************************************
// B3dRadialLight.
/*************************************/

class B3dLight : public B3dThing {

/*************************************
// LOW-LEVEL API                    */

 public:
	float    power;
	short    type;
	
	B3dLight(char *name, B3dWorld *world, float power, RGBAColor *color);
	virtual ~B3dLight();
};

#endif







