/*****************************************************************************
//
//	File:		    3dImport.h
//
//	Description:	Classes for importing and exporting in common file formats
//
//	Copyright 1997, Be Incorporated
//
//***************************************************************************/

#ifndef _3D_IMPORT_H
#define _3D_IMPORT_H

class B3dChannelServer;

class B3dImporter
{

	public:

						B3dImporter();
						B3dImporter(	BPath *path,
									B3dChannelServer *channelServer=NULL);
						B3dImporter(	const char *path,
									B3dChannelServer *channelServer=NULL);
virtual					~B3dImporter();

		status_t			SetChannelServer(B3dChannelServer *server);
virtual	status_t			ImportFace(B3dFaceBody **object, B3dWorld *world);
virtual	status_t			ImportClump(B3dClump **clump)=0;

	protected:
	
		FILE *			m_file;
		B3dChannelServer *	m_channelServer;
};

class B3dExporter
{

	public:

						B3dExporter();
						B3dExporter(BPath *path);
						B3dExporter(const char *path);
virtual					~B3dExporter();

virtual	status_t			ExportFace(B3dFaceBody *object)=0;
virtual	status_t			ExportClump(B3dClump *clump)=0;

	protected:
	
		FILE *			m_file;
};

class B3dVRMLImporter : public B3dImporter
{
	public:

						B3dVRMLImporter(	BPath *path,
										B3dChannelServer *channelServer=NULL);
						B3dVRMLImporter(	const char *path,
										B3dChannelServer *channelServer=NULL);
						~B3dVRMLImporter();

		void				SetTargetScale(float size=1.0);
		void				SetShapeHints(bool solid, bool clockwise,
									  bool overrideFileSettings=FALSE);
virtual	status_t			ImportClump(B3dClump **clump);

	private:
	
	char				m_filename[256];
	void				*m_privateStuff;

};

class B3dRWXImporter : public B3dImporter
{

	public:

						B3dRWXImporter(BPath *path) : B3dImporter(path) {};
						B3dRWXImporter(const char *path) : B3dImporter(path) {};

virtual	status_t			ImportClump(B3dClump **clump);
};

class B3dTeapotImporter : public B3dImporter
{

	public:

						B3dTeapotImporter(BPath *path) : B3dImporter(path) {};
						B3dTeapotImporter(const char *path) : B3dImporter(path) {};

virtual	status_t			ImportClump(B3dClump **clump);
};

#endif
