/*****************************************************************************
//
//	File:			3dFaceLook.h
//
//	Description:	Appearance descriptor for 3dFace object.
//
//	Copyright 1997, Be Incorporated
//
//***************************************************************************/

#ifndef _3D_FACE_LOOK_H
#define _3D_FACE_LOOK_H

#include "3dRenderer.h"
#include "3dFaceModel.h"
#include "3dLook.h"

/* enum for the mask in m_flags */
enum {
	B_3D_LOCAL_RENDER_ID	= 0x00000001, /* Each face has it's own rendering requirements */
	B_3D_LOCAL_FACE_LOOK	= 0x00000002, /* There is one material per face */
	B_3D_SHARED_POINT_LOOK	= 0x00000004,	/* There is one point look per point */
	B_3D_LOCAL_POINT_LOOK	= 0x00000008, /* There are three point looks per face */
	B_3D_BACKS_VISIBLE		= 0x00000010  /* Face backs are visible */
};

class B3dLightProc;
class B3dPackedMaterial;
class B3dPackedPointLook;
class B3dFaceBody;
class B3dFaceModel;
class B3dMaterial;
class B3dPointLook;

typedef uint32 render_id;

typedef struct 
{
	uint32				flags;
	render_id *			renderIDs;
	B3dPackedMaterial **	materials;
	B3dPackedPointLook **	pointLooks;
	void *				materialBuffer;
	uint32				materialBufferSize;
	void *				pointLookBuffer;
	uint32				pointLookBufferSize;
} B3dPackedFaceLookDesc;

typedef struct
{
	uint32				flags;

	int32 *				materialIndices;
	int32 *				pointLookIndices;

	int32				numMaterials;
	int32				numPointLooks;
	B3dMaterial *			materials;
	B3dPointLook *		pointLooks;
} B3dFaceLookDesc;

class B3dFaceLook : public B3dLook
{

	public:

	uint32					m_flags;

	render_id					m_globalRenderID;
	BArray<render_id>			m_renderIDs;

	BArray<B3dPackedMaterial*>	m_materials;
	BArray<B3dPackedPointLook*>	m_pointLooks;
	
	void						*m_pointLookBuffer;
	uint32					m_pointLookBufferSize;
	uint32					m_pointLookBufferEnd;

	void						*m_materialBuffer;
	uint32					m_materialBufferSize;
	uint32					m_materialBufferEnd;

							B3dFaceLook(	const char *			name,
										B3dFaceModel *		model,
										B3dFaceLookDesc *		desc,
										uint32				creationFlags=0);
							B3dFaceLook(	const char *			name,
										B3dFaceModel *		model,
										B3dPackedFaceLookDesc *	desc,
										uint32				creationFlags=0);
virtual						~B3dFaceLook();

virtual	void					Draw(		ulong				clip_flag,
										B3dMatrix				*Rot,
										B3dVector				*Trans,
										B3dLens				*Proj,
										B3dRenderer			*Render,
										B3dLightProc			*lightProc,
										B3dSharedState		*buf);

	private:

		friend				B3dFaceBody;

		void					Construct(	B3dPackedFaceLookDesc	*desc,
										uint32				creationFlags);

		B3dPackedPointLook *	AddPointLook(B3dPointLook *pointLook, int32 has);
		B3dPackedMaterial *	AddMaterial(B3dMaterial *material, int32 has);
		render_id				RenderIDForFace(int32 faceNum);
		int32				PointLookLen(render_id rid);
};

#endif
