
#include "wGlobe.h"

wGlobe::wGlobe(	char *name,
				B3dWorld *world,
				int32 bands, int32 rotations,
				B3dChannel *texture)
				: B3dSpin(name,world,
					CreateSpinDesc(bands,rotations,texture),
					B_OWN_DESC)
{
};

B3dSpinDesc *	wGlobe::CreateSpinDesc(int32 bands, int32 rotations, B3dChannel *texture)
{
	B3dSpinDesc *desc = new B3dSpinDesc;
	int32 sc = bands + 1;
	int32 rc = rotations;
	B2dVector *shape = new B2dVector[sc];
	float angle,cs,sn;
	
	shape[0].x = 0;
	shape[0].y = -1.0;
	shape[sc-1].x = 0;
	shape[sc-1].y = 1.0;

	for (int32 i=1;i<sc-1;i++) {
		angle = (PI*i)/(sc-1);
		cs = b_cos(angle);
		sn = b_sin(angle);
		shape[i].x = sn;
		shape[i].y = -cs;
	};
	
	desc->shapeCount = sc;
	desc->shape = shape;
	desc->radiusCount = rc;
	desc->texture = texture;
	desc->textureRepeatX = 1;
	desc->textureRepeatY = 1;

	return desc;
};
