/* valaelementaccess.c generated by valac, the Vala compiler
 * generated from valaelementaccess.vala, do not modify */

/* valaelementaccess.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 * Copyright (C) 2006-2008  Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Raffaele Sandrini <raffaele@sandrini.ch>
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <valagee.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _ValaElementAccessPrivate {
	ValaList* indices;
	ValaExpression* _container;
};

static gint ValaElementAccess_private_offset;
static gpointer vala_element_access_parent_class = NULL;

static void vala_element_access_real_accept (ValaCodeNode* base,
                                      ValaCodeVisitor* visitor);
static void vala_element_access_real_accept_children (ValaCodeNode* base,
                                               ValaCodeVisitor* visitor);
static gchar* vala_element_access_real_to_string (ValaCodeNode* base);
static void vala_element_access_real_replace_expression (ValaCodeNode* base,
                                                  ValaExpression* old_node,
                                                  ValaExpression* new_node);
static gboolean vala_element_access_real_is_pure (ValaExpression* base);
static gboolean vala_element_access_real_is_accessible (ValaExpression* base,
                                                 ValaSymbol* sym);
static void vala_element_access_real_get_error_types (ValaCodeNode* base,
                                               ValaCollection* collection,
                                               ValaSourceReference* source_reference);
static gboolean vala_element_access_real_check (ValaCodeNode* base,
                                         ValaCodeContext* context);
static void vala_element_access_real_emit (ValaCodeNode* base,
                                    ValaCodeGenerator* codegen);
static void vala_element_access_real_get_defined_variables (ValaCodeNode* base,
                                                     ValaCollection* collection);
static void vala_element_access_real_get_used_variables (ValaCodeNode* base,
                                                  ValaCollection* collection);
static void vala_element_access_finalize (ValaCodeNode * obj);
static GType vala_element_access_get_type_once (void);

static inline gpointer
vala_element_access_get_instance_private (ValaElementAccess* self)
{
	return G_STRUCT_MEMBER_P (self, ValaElementAccess_private_offset);
}

ValaExpression*
vala_element_access_get_container (ValaElementAccess* self)
{
	ValaExpression* result;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_container;
	result = _tmp0_;
	return result;
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

void
vala_element_access_set_container (ValaElementAccess* self,
                                   ValaExpression* value)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_container);
	self->priv->_container = _tmp0_;
	_tmp1_ = self->priv->_container;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
}

void
vala_element_access_append_index (ValaElementAccess* self,
                                  ValaExpression* index)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (index != NULL);
	_tmp0_ = self->priv->indices;
	vala_collection_add ((ValaCollection*) _tmp0_, index);
	vala_code_node_set_parent_node ((ValaCodeNode*) index, (ValaCodeNode*) self);
}

ValaList*
vala_element_access_get_indices (ValaElementAccess* self)
{
	ValaList* _tmp0_;
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->indices;
	result = _tmp0_;
	return result;
}

ValaElementAccess*
vala_element_access_construct (GType object_type,
                               ValaExpression* container,
                               ValaSourceReference* source_reference)
{
	ValaElementAccess* self = NULL;
	g_return_val_if_fail (container != NULL, NULL);
	self = (ValaElementAccess*) vala_expression_construct (object_type);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	vala_element_access_set_container (self, container);
	return self;
}

ValaElementAccess*
vala_element_access_new (ValaExpression* container,
                         ValaSourceReference* source_reference)
{
	return vala_element_access_construct (VALA_TYPE_ELEMENT_ACCESS, container, source_reference);
}

static void
vala_element_access_real_accept (ValaCodeNode* base,
                                 ValaCodeVisitor* visitor)
{
	ValaElementAccess * self;
	self = (ValaElementAccess*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_element_access (visitor, self);
	vala_code_visitor_visit_expression (visitor, (ValaExpression*) self);
}

static void
vala_element_access_real_accept_children (ValaCodeNode* base,
                                          ValaCodeVisitor* visitor)
{
	ValaElementAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaElementAccess*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_element_access_get_container (self);
	_tmp1_ = _tmp0_;
	vala_code_node_accept ((ValaCodeNode*) _tmp1_, visitor);
	{
		ValaList* _e_list = NULL;
		ValaList* _tmp2_;
		gint _e_size = 0;
		ValaList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _e_index = 0;
		_tmp2_ = self->priv->indices;
		_e_list = _tmp2_;
		_tmp3_ = _e_list;
		_tmp4_ = vala_collection_get_size ((ValaCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_e_size = _tmp5_;
		_e_index = -1;
		while (TRUE) {
			gint _tmp6_;
			gint _tmp7_;
			ValaExpression* e = NULL;
			ValaList* _tmp8_;
			gpointer _tmp9_;
			ValaExpression* _tmp10_;
			_e_index = _e_index + 1;
			_tmp6_ = _e_index;
			_tmp7_ = _e_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _e_list;
			_tmp9_ = vala_list_get (_tmp8_, _e_index);
			e = (ValaExpression*) _tmp9_;
			_tmp10_ = e;
			vala_code_node_accept ((ValaCodeNode*) _tmp10_, visitor);
			_vala_code_node_unref0 (e);
		}
	}
}

static gchar*
vala_element_access_real_to_string (ValaCodeNode* base)
{
	ValaElementAccess * self;
	gchar* s = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gboolean first = FALSE;
	const gchar* _tmp26_;
	gchar* _tmp27_;
	gchar* result = NULL;
	self = (ValaElementAccess*) base;
	_tmp0_ = vala_element_access_get_container (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_code_node_to_string ((ValaCodeNode*) _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strdup_printf ("%s[", _tmp3_);
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp3_);
	s = _tmp5_;
	first = TRUE;
	{
		ValaList* _index_list = NULL;
		ValaList* _tmp6_;
		gint _index_size = 0;
		ValaList* _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
		gint _index_index = 0;
		_tmp6_ = self->priv->indices;
		_index_list = _tmp6_;
		_tmp7_ = _index_list;
		_tmp8_ = vala_collection_get_size ((ValaCollection*) _tmp7_);
		_tmp9_ = _tmp8_;
		_index_size = _tmp9_;
		_index_index = -1;
		while (TRUE) {
			gint _tmp10_;
			gint _tmp11_;
			ValaExpression* index = NULL;
			ValaList* _tmp12_;
			gpointer _tmp13_;
			_index_index = _index_index + 1;
			_tmp10_ = _index_index;
			_tmp11_ = _index_size;
			if (!(_tmp10_ < _tmp11_)) {
				break;
			}
			_tmp12_ = _index_list;
			_tmp13_ = vala_list_get (_tmp12_, _index_index);
			index = (ValaExpression*) _tmp13_;
			if (first) {
				const gchar* _tmp14_;
				ValaExpression* _tmp15_;
				gchar* _tmp16_;
				gchar* _tmp17_;
				gchar* _tmp18_;
				_tmp14_ = s;
				_tmp15_ = index;
				_tmp16_ = vala_code_node_to_string ((ValaCodeNode*) _tmp15_);
				_tmp17_ = _tmp16_;
				_tmp18_ = g_strconcat (_tmp14_, _tmp17_, NULL);
				_g_free0 (s);
				s = _tmp18_;
				_g_free0 (_tmp17_);
				first = FALSE;
			} else {
				const gchar* _tmp19_;
				ValaExpression* _tmp20_;
				gchar* _tmp21_;
				gchar* _tmp22_;
				gchar* _tmp23_;
				gchar* _tmp24_;
				gchar* _tmp25_;
				_tmp19_ = s;
				_tmp20_ = index;
				_tmp21_ = vala_code_node_to_string ((ValaCodeNode*) _tmp20_);
				_tmp22_ = _tmp21_;
				_tmp23_ = g_strdup_printf (", %s", _tmp22_);
				_tmp24_ = _tmp23_;
				_tmp25_ = g_strconcat (_tmp19_, _tmp24_, NULL);
				_g_free0 (s);
				s = _tmp25_;
				_g_free0 (_tmp24_);
				_g_free0 (_tmp22_);
			}
			_vala_code_node_unref0 (index);
		}
	}
	_tmp26_ = s;
	_tmp27_ = g_strconcat (_tmp26_, "]", NULL);
	result = _tmp27_;
	_g_free0 (s);
	return result;
}

static void
vala_element_access_real_replace_expression (ValaCodeNode* base,
                                             ValaExpression* old_node,
                                             ValaExpression* new_node)
{
	ValaElementAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	gint index = 0;
	ValaList* _tmp2_;
	self = (ValaElementAccess*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = vala_element_access_get_container (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_node) {
		vala_element_access_set_container (self, new_node);
	}
	_tmp2_ = self->priv->indices;
	index = vala_list_index_of (_tmp2_, old_node);
	if (index >= 0) {
		ValaList* _tmp3_;
		_tmp3_ = self->priv->indices;
		vala_list_set (_tmp3_, index, new_node);
		vala_code_node_set_parent_node ((ValaCodeNode*) new_node, (ValaCodeNode*) self);
	}
}

static gboolean
vala_element_access_real_is_pure (ValaExpression* base)
{
	ValaElementAccess * self;
	ValaExpression* _tmp9_;
	ValaExpression* _tmp10_;
	gboolean result = FALSE;
	self = (ValaElementAccess*) base;
	{
		ValaList* _index_list = NULL;
		ValaList* _tmp0_;
		gint _index_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _index_index = 0;
		_tmp0_ = self->priv->indices;
		_index_list = _tmp0_;
		_tmp1_ = _index_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_index_size = _tmp3_;
		_index_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			ValaExpression* index = NULL;
			ValaList* _tmp6_;
			gpointer _tmp7_;
			ValaExpression* _tmp8_;
			_index_index = _index_index + 1;
			_tmp4_ = _index_index;
			_tmp5_ = _index_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _index_list;
			_tmp7_ = vala_list_get (_tmp6_, _index_index);
			index = (ValaExpression*) _tmp7_;
			_tmp8_ = index;
			if (!vala_expression_is_pure (_tmp8_)) {
				result = FALSE;
				_vala_code_node_unref0 (index);
				return result;
			}
			_vala_code_node_unref0 (index);
		}
	}
	_tmp9_ = vala_element_access_get_container (self);
	_tmp10_ = _tmp9_;
	result = vala_expression_is_pure (_tmp10_);
	return result;
}

static gboolean
vala_element_access_real_is_accessible (ValaExpression* base,
                                        ValaSymbol* sym)
{
	ValaElementAccess * self;
	ValaExpression* _tmp9_;
	ValaExpression* _tmp10_;
	gboolean result = FALSE;
	self = (ValaElementAccess*) base;
	g_return_val_if_fail (sym != NULL, FALSE);
	{
		ValaList* _index_list = NULL;
		ValaList* _tmp0_;
		gint _index_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _index_index = 0;
		_tmp0_ = self->priv->indices;
		_index_list = _tmp0_;
		_tmp1_ = _index_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_index_size = _tmp3_;
		_index_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			ValaExpression* index = NULL;
			ValaList* _tmp6_;
			gpointer _tmp7_;
			ValaExpression* _tmp8_;
			_index_index = _index_index + 1;
			_tmp4_ = _index_index;
			_tmp5_ = _index_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _index_list;
			_tmp7_ = vala_list_get (_tmp6_, _index_index);
			index = (ValaExpression*) _tmp7_;
			_tmp8_ = index;
			if (!vala_expression_is_accessible (_tmp8_, sym)) {
				result = FALSE;
				_vala_code_node_unref0 (index);
				return result;
			}
			_vala_code_node_unref0 (index);
		}
	}
	_tmp9_ = vala_element_access_get_container (self);
	_tmp10_ = _tmp9_;
	result = vala_expression_is_accessible (_tmp10_, sym);
	return result;
}

static void
vala_element_access_real_get_error_types (ValaCodeNode* base,
                                          ValaCollection* collection,
                                          ValaSourceReference* source_reference)
{
	ValaElementAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaElementAccess*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_element_access_get_container (self);
	_tmp1_ = _tmp0_;
	vala_code_node_get_error_types ((ValaCodeNode*) _tmp1_, collection, source_reference);
	{
		ValaList* _e_list = NULL;
		ValaList* _tmp2_;
		gint _e_size = 0;
		ValaList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _e_index = 0;
		_tmp2_ = self->priv->indices;
		_e_list = _tmp2_;
		_tmp3_ = _e_list;
		_tmp4_ = vala_collection_get_size ((ValaCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_e_size = _tmp5_;
		_e_index = -1;
		while (TRUE) {
			gint _tmp6_;
			gint _tmp7_;
			ValaExpression* e = NULL;
			ValaList* _tmp8_;
			gpointer _tmp9_;
			ValaExpression* _tmp10_;
			_e_index = _e_index + 1;
			_tmp6_ = _e_index;
			_tmp7_ = _e_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _e_list;
			_tmp9_ = vala_list_get (_tmp8_, _e_index);
			e = (ValaExpression*) _tmp9_;
			_tmp10_ = e;
			vala_code_node_get_error_types ((ValaCodeNode*) _tmp10_, collection, source_reference);
			_vala_code_node_unref0 (e);
		}
	}
}

static gboolean
vala_element_access_real_check (ValaCodeNode* base,
                                ValaCodeContext* context)
{
	ValaElementAccess * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaExpression* _tmp4_;
	ValaExpression* _tmp5_;
	ValaExpression* _tmp6_;
	ValaExpression* _tmp7_;
	ValaDataType* _tmp8_;
	ValaDataType* _tmp9_;
	gboolean _tmp14_ = FALSE;
	ValaExpression* _tmp15_;
	ValaExpression* _tmp16_;
	gboolean index_int_type_check = FALSE;
	ValaPointerType* pointer_type = NULL;
	ValaExpression* _tmp57_;
	ValaExpression* _tmp58_;
	ValaDataType* _tmp59_;
	ValaDataType* _tmp60_;
	ValaExpression* _tmp61_;
	ValaExpression* _tmp62_;
	ValaDataType* _tmp63_;
	ValaDataType* _tmp64_;
	ValaDataType* _tmp263_;
	ValaDataType* _tmp264_;
	gboolean _tmp265_;
	gboolean _tmp266_;
	gboolean result = FALSE;
	self = (ValaElementAccess*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_element_access_get_container (self);
	_tmp5_ = _tmp4_;
	if (!vala_code_node_check ((ValaCodeNode*) _tmp5_, context)) {
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		return result;
	}
	_tmp6_ = vala_element_access_get_container (self);
	_tmp7_ = _tmp6_;
	_tmp8_ = vala_expression_get_value_type (_tmp7_);
	_tmp9_ = _tmp8_;
	if (_tmp9_ == NULL) {
		ValaExpression* _tmp10_;
		ValaExpression* _tmp11_;
		ValaSourceReference* _tmp12_;
		ValaSourceReference* _tmp13_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp10_ = vala_element_access_get_container (self);
		_tmp11_ = _tmp10_;
		_tmp12_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp11_);
		_tmp13_ = _tmp12_;
		vala_report_error (_tmp13_, "Invalid container expression");
		result = FALSE;
		return result;
	}
	_tmp15_ = vala_element_access_get_container (self);
	_tmp16_ = _tmp15_;
	if (VALA_IS_MEMBER_ACCESS (_tmp16_)) {
		ValaExpression* _tmp17_;
		ValaExpression* _tmp18_;
		ValaSymbol* _tmp19_;
		ValaSymbol* _tmp20_;
		_tmp17_ = vala_element_access_get_container (self);
		_tmp18_ = _tmp17_;
		_tmp19_ = vala_expression_get_symbol_reference (_tmp18_);
		_tmp20_ = _tmp19_;
		_tmp14_ = VALA_IS_SIGNAL (_tmp20_);
	} else {
		_tmp14_ = FALSE;
	}
	if (_tmp14_) {
		ValaList* _tmp21_;
		gint _tmp22_;
		gint _tmp23_;
		ValaExpression* detail_expr = NULL;
		ValaList* _tmp26_;
		gpointer _tmp27_;
		ValaExpression* _tmp28_;
		ValaSemanticAnalyzer* _tmp29_;
		ValaSemanticAnalyzer* _tmp30_;
		ValaDataType* _tmp31_;
		ValaDataType* _tmp32_;
		ValaDataType* _tmp33_;
		ValaExpression* _tmp34_;
		gboolean _tmp35_ = FALSE;
		ValaExpression* _tmp36_;
		ValaDataType* _tmp37_;
		ValaDataType* _tmp38_;
		_tmp21_ = vala_element_access_get_indices (self);
		_tmp22_ = vala_collection_get_size ((ValaCollection*) _tmp21_);
		_tmp23_ = _tmp22_;
		if (_tmp23_ != 1) {
			ValaSourceReference* _tmp24_;
			ValaSourceReference* _tmp25_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp24_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp25_ = _tmp24_;
			vala_report_error (_tmp25_, "Element access with more than one dimension is not supported for signa" \
"ls");
			result = FALSE;
			return result;
		}
		_tmp26_ = vala_element_access_get_indices (self);
		_tmp27_ = vala_list_get (_tmp26_, 0);
		detail_expr = (ValaExpression*) _tmp27_;
		_tmp28_ = detail_expr;
		_tmp29_ = vala_code_context_get_analyzer (context);
		_tmp30_ = _tmp29_;
		_tmp31_ = _tmp30_->string_type;
		_tmp32_ = vala_data_type_copy (_tmp31_);
		_tmp33_ = _tmp32_;
		vala_expression_set_target_type (_tmp28_, _tmp33_);
		_vala_code_node_unref0 (_tmp33_);
		_tmp34_ = detail_expr;
		vala_code_node_check ((ValaCodeNode*) _tmp34_, context);
		_tmp36_ = detail_expr;
		_tmp37_ = vala_expression_get_value_type (_tmp36_);
		_tmp38_ = _tmp37_;
		if (VALA_IS_NULL_TYPE (_tmp38_)) {
			_tmp35_ = TRUE;
		} else {
			ValaExpression* _tmp39_;
			ValaDataType* _tmp40_;
			ValaDataType* _tmp41_;
			ValaSemanticAnalyzer* _tmp42_;
			ValaSemanticAnalyzer* _tmp43_;
			ValaDataType* _tmp44_;
			_tmp39_ = detail_expr;
			_tmp40_ = vala_expression_get_value_type (_tmp39_);
			_tmp41_ = _tmp40_;
			_tmp42_ = vala_code_context_get_analyzer (context);
			_tmp43_ = _tmp42_;
			_tmp44_ = _tmp43_->string_type;
			_tmp35_ = !vala_data_type_compatible (_tmp41_, _tmp44_);
		}
		if (_tmp35_) {
			ValaExpression* _tmp45_;
			ValaSourceReference* _tmp46_;
			ValaSourceReference* _tmp47_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp45_ = detail_expr;
			_tmp46_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp45_);
			_tmp47_ = _tmp46_;
			vala_report_error (_tmp47_, "only string details are supported");
			result = FALSE;
			_vala_code_node_unref0 (detail_expr);
			return result;
		}
		_vala_code_node_unref0 (detail_expr);
	}
	{
		ValaList* _index_list = NULL;
		ValaList* _tmp48_;
		gint _index_size = 0;
		ValaList* _tmp49_;
		gint _tmp50_;
		gint _tmp51_;
		gint _index_index = 0;
		_tmp48_ = vala_element_access_get_indices (self);
		_index_list = _tmp48_;
		_tmp49_ = _index_list;
		_tmp50_ = vala_collection_get_size ((ValaCollection*) _tmp49_);
		_tmp51_ = _tmp50_;
		_index_size = _tmp51_;
		_index_index = -1;
		while (TRUE) {
			gint _tmp52_;
			gint _tmp53_;
			ValaExpression* index = NULL;
			ValaList* _tmp54_;
			gpointer _tmp55_;
			ValaExpression* _tmp56_;
			_index_index = _index_index + 1;
			_tmp52_ = _index_index;
			_tmp53_ = _index_size;
			if (!(_tmp52_ < _tmp53_)) {
				break;
			}
			_tmp54_ = _index_list;
			_tmp55_ = vala_list_get (_tmp54_, _index_index);
			index = (ValaExpression*) _tmp55_;
			_tmp56_ = index;
			vala_code_node_check ((ValaCodeNode*) _tmp56_, context);
			_vala_code_node_unref0 (index);
		}
	}
	index_int_type_check = TRUE;
	_tmp57_ = vala_element_access_get_container (self);
	_tmp58_ = _tmp57_;
	_tmp59_ = vala_expression_get_value_type (_tmp58_);
	_tmp60_ = _tmp59_;
	pointer_type = VALA_IS_POINTER_TYPE (_tmp60_) ? ((ValaPointerType*) _tmp60_) : NULL;
	_tmp61_ = vala_element_access_get_container (self);
	_tmp62_ = _tmp61_;
	_tmp63_ = vala_expression_get_value_type (_tmp62_);
	_tmp64_ = _tmp63_;
	if (VALA_IS_ARRAY_TYPE (_tmp64_)) {
		ValaArrayType* array_type = NULL;
		ValaExpression* _tmp65_;
		ValaExpression* _tmp66_;
		ValaDataType* _tmp67_;
		ValaDataType* _tmp68_;
		ValaArrayType* _tmp69_;
		ValaDataType* _tmp70_;
		ValaDataType* _tmp71_;
		ValaDataType* _tmp72_;
		ValaDataType* _tmp73_;
		gboolean _tmp74_;
		gboolean _tmp75_;
		ValaArrayType* _tmp125_;
		gint _tmp126_;
		gint _tmp127_;
		ValaList* _tmp128_;
		gint _tmp129_;
		gint _tmp130_;
		_tmp65_ = vala_element_access_get_container (self);
		_tmp66_ = _tmp65_;
		_tmp67_ = vala_expression_get_value_type (_tmp66_);
		_tmp68_ = _tmp67_;
		array_type = G_TYPE_CHECK_INSTANCE_CAST (_tmp68_, VALA_TYPE_ARRAY_TYPE, ValaArrayType);
		_tmp69_ = array_type;
		_tmp70_ = vala_array_type_get_element_type (_tmp69_);
		_tmp71_ = _tmp70_;
		_tmp72_ = vala_data_type_copy (_tmp71_);
		_tmp73_ = _tmp72_;
		vala_expression_set_value_type ((ValaExpression*) self, _tmp73_);
		_vala_code_node_unref0 (_tmp73_);
		_tmp74_ = vala_expression_get_lvalue ((ValaExpression*) self);
		_tmp75_ = _tmp74_;
		if (!_tmp75_) {
			ValaDataType* _tmp76_;
			ValaDataType* _tmp77_;
			_tmp76_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp77_ = _tmp76_;
			vala_data_type_set_value_owned (_tmp77_, FALSE);
		} else {
			ValaMemberAccess* ma = NULL;
			ValaExpression* _tmp78_;
			ValaExpression* _tmp79_;
			gboolean _tmp80_ = FALSE;
			gboolean _tmp81_ = FALSE;
			ValaProfile _tmp82_;
			ValaProfile _tmp83_;
			_tmp78_ = vala_element_access_get_container (self);
			_tmp79_ = _tmp78_;
			ma = VALA_IS_MEMBER_ACCESS (_tmp79_) ? ((ValaMemberAccess*) _tmp79_) : NULL;
			_tmp82_ = vala_code_context_get_profile (context);
			_tmp83_ = _tmp82_;
			if (_tmp83_ == VALA_PROFILE_GOBJECT) {
				ValaMemberAccess* _tmp84_;
				_tmp84_ = ma;
				_tmp81_ = _tmp84_ != NULL;
			} else {
				_tmp81_ = FALSE;
			}
			if (_tmp81_) {
				ValaMemberAccess* _tmp85_;
				ValaSymbol* _tmp86_;
				ValaSymbol* _tmp87_;
				_tmp85_ = ma;
				_tmp86_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp85_);
				_tmp87_ = _tmp86_;
				_tmp80_ = VALA_IS_ARRAY_LENGTH_FIELD (_tmp87_);
			} else {
				_tmp80_ = FALSE;
			}
			if (_tmp80_) {
				ValaMemberAccess* _tmp88_;
				ValaExpression* _tmp89_;
				ValaExpression* _tmp90_;
				ValaMemberAccess* _tmp91_;
				ValaExpression* _tmp92_;
				ValaExpression* _tmp93_;
				_tmp88_ = ma;
				_tmp89_ = vala_member_access_get_inner (_tmp88_);
				_tmp90_ = _tmp89_;
				vala_expression_set_lvalue (_tmp90_, TRUE);
				_tmp91_ = ma;
				_tmp92_ = vala_member_access_get_inner (_tmp91_);
				_tmp93_ = _tmp92_;
				vala_member_access_check_lvalue_access (G_TYPE_CHECK_INSTANCE_CAST (_tmp93_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
			} else {
				gboolean _tmp94_ = FALSE;
				gboolean _tmp95_ = FALSE;
				gboolean _tmp96_ = FALSE;
				gboolean _tmp97_ = FALSE;
				gboolean _tmp98_ = FALSE;
				ValaMemberAccess* _tmp99_;
				_tmp99_ = ma;
				if (_tmp99_ != NULL) {
					ValaMemberAccess* _tmp100_;
					ValaSymbol* _tmp101_;
					ValaSymbol* _tmp102_;
					_tmp100_ = ma;
					_tmp101_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp100_);
					_tmp102_ = _tmp101_;
					_tmp98_ = VALA_IS_FIELD (_tmp102_);
				} else {
					_tmp98_ = FALSE;
				}
				if (_tmp98_) {
					ValaMemberAccess* _tmp103_;
					ValaExpression* _tmp104_;
					ValaExpression* _tmp105_;
					_tmp103_ = ma;
					_tmp104_ = vala_member_access_get_inner (_tmp103_);
					_tmp105_ = _tmp104_;
					_tmp97_ = _tmp105_ != NULL;
				} else {
					_tmp97_ = FALSE;
				}
				if (_tmp97_) {
					ValaMemberAccess* _tmp106_;
					ValaExpression* _tmp107_;
					ValaExpression* _tmp108_;
					ValaSymbol* _tmp109_;
					ValaSymbol* _tmp110_;
					_tmp106_ = ma;
					_tmp107_ = vala_member_access_get_inner (_tmp106_);
					_tmp108_ = _tmp107_;
					_tmp109_ = vala_expression_get_symbol_reference (_tmp108_);
					_tmp110_ = _tmp109_;
					_tmp96_ = VALA_IS_VARIABLE (_tmp110_);
				} else {
					_tmp96_ = FALSE;
				}
				if (_tmp96_) {
					ValaMemberAccess* _tmp111_;
					ValaExpression* _tmp112_;
					ValaExpression* _tmp113_;
					ValaDataType* _tmp114_;
					ValaDataType* _tmp115_;
					_tmp111_ = ma;
					_tmp112_ = vala_member_access_get_inner (_tmp111_);
					_tmp113_ = _tmp112_;
					_tmp114_ = vala_expression_get_value_type (_tmp113_);
					_tmp115_ = _tmp114_;
					_tmp95_ = VALA_IS_STRUCT_VALUE_TYPE (_tmp115_);
				} else {
					_tmp95_ = FALSE;
				}
				if (_tmp95_) {
					ValaMemberAccess* _tmp116_;
					ValaExpression* _tmp117_;
					ValaExpression* _tmp118_;
					ValaDataType* _tmp119_;
					ValaDataType* _tmp120_;
					gboolean _tmp121_;
					gboolean _tmp122_;
					_tmp116_ = ma;
					_tmp117_ = vala_member_access_get_inner (_tmp116_);
					_tmp118_ = _tmp117_;
					_tmp119_ = vala_expression_get_value_type (_tmp118_);
					_tmp120_ = _tmp119_;
					_tmp121_ = vala_data_type_get_nullable (_tmp120_);
					_tmp122_ = _tmp121_;
					_tmp94_ = !_tmp122_;
				} else {
					_tmp94_ = FALSE;
				}
				if (_tmp94_) {
					ValaMemberAccess* _tmp123_;
					ValaMemberAccess* _tmp124_;
					_tmp123_ = ma;
					vala_expression_set_lvalue ((ValaExpression*) _tmp123_, TRUE);
					_tmp124_ = ma;
					vala_member_access_check_lvalue_access (_tmp124_);
				}
			}
		}
		_tmp125_ = array_type;
		_tmp126_ = vala_array_type_get_rank (_tmp125_);
		_tmp127_ = _tmp126_;
		_tmp128_ = vala_element_access_get_indices (self);
		_tmp129_ = vala_collection_get_size ((ValaCollection*) _tmp128_);
		_tmp130_ = _tmp129_;
		if (_tmp127_ < _tmp130_) {
			ValaSourceReference* _tmp131_;
			ValaSourceReference* _tmp132_;
			ValaList* _tmp133_;
			gint _tmp134_;
			gint _tmp135_;
			ValaArrayType* _tmp136_;
			gint _tmp137_;
			gint _tmp138_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp131_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp132_ = _tmp131_;
			_tmp133_ = vala_element_access_get_indices (self);
			_tmp134_ = vala_collection_get_size ((ValaCollection*) _tmp133_);
			_tmp135_ = _tmp134_;
			_tmp136_ = array_type;
			_tmp137_ = vala_array_type_get_rank (_tmp136_);
			_tmp138_ = _tmp137_;
			vala_report_error (_tmp132_, "%d extra indices for element access", _tmp135_ - _tmp138_);
		} else {
			ValaArrayType* _tmp139_;
			gint _tmp140_;
			gint _tmp141_;
			ValaList* _tmp142_;
			gint _tmp143_;
			gint _tmp144_;
			_tmp139_ = array_type;
			_tmp140_ = vala_array_type_get_rank (_tmp139_);
			_tmp141_ = _tmp140_;
			_tmp142_ = vala_element_access_get_indices (self);
			_tmp143_ = vala_collection_get_size ((ValaCollection*) _tmp142_);
			_tmp144_ = _tmp143_;
			if (_tmp141_ > _tmp144_) {
				ValaSourceReference* _tmp145_;
				ValaSourceReference* _tmp146_;
				ValaArrayType* _tmp147_;
				gint _tmp148_;
				gint _tmp149_;
				ValaList* _tmp150_;
				gint _tmp151_;
				gint _tmp152_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp145_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp146_ = _tmp145_;
				_tmp147_ = array_type;
				_tmp148_ = vala_array_type_get_rank (_tmp147_);
				_tmp149_ = _tmp148_;
				_tmp150_ = vala_element_access_get_indices (self);
				_tmp151_ = vala_collection_get_size ((ValaCollection*) _tmp150_);
				_tmp152_ = _tmp151_;
				vala_report_error (_tmp146_, "%d missing indices for element access", _tmp149_ - _tmp152_);
			}
		}
	} else {
		gboolean _tmp153_ = FALSE;
		ValaPointerType* _tmp154_;
		_tmp154_ = pointer_type;
		if (_tmp154_ != NULL) {
			ValaPointerType* _tmp155_;
			ValaDataType* _tmp156_;
			ValaDataType* _tmp157_;
			_tmp155_ = pointer_type;
			_tmp156_ = vala_pointer_type_get_base_type (_tmp155_);
			_tmp157_ = _tmp156_;
			_tmp153_ = !vala_data_type_is_reference_type_or_type_parameter (_tmp157_);
		} else {
			_tmp153_ = FALSE;
		}
		if (_tmp153_) {
			ValaPointerType* _tmp158_;
			ValaDataType* _tmp159_;
			ValaDataType* _tmp160_;
			ValaDataType* _tmp161_;
			ValaDataType* _tmp162_;
			_tmp158_ = pointer_type;
			_tmp159_ = vala_pointer_type_get_base_type (_tmp158_);
			_tmp160_ = _tmp159_;
			_tmp161_ = vala_data_type_copy (_tmp160_);
			_tmp162_ = _tmp161_;
			vala_expression_set_value_type ((ValaExpression*) self, _tmp162_);
			_vala_code_node_unref0 (_tmp162_);
		} else {
			gboolean _tmp163_ = FALSE;
			ValaExpression* _tmp164_;
			ValaExpression* _tmp165_;
			_tmp164_ = vala_element_access_get_container (self);
			_tmp165_ = _tmp164_;
			if (VALA_IS_MEMBER_ACCESS (_tmp165_)) {
				ValaExpression* _tmp166_;
				ValaExpression* _tmp167_;
				ValaSymbol* _tmp168_;
				ValaSymbol* _tmp169_;
				_tmp166_ = vala_element_access_get_container (self);
				_tmp167_ = _tmp166_;
				_tmp168_ = vala_expression_get_symbol_reference (_tmp167_);
				_tmp169_ = _tmp168_;
				_tmp163_ = VALA_IS_SIGNAL (_tmp169_);
			} else {
				_tmp163_ = FALSE;
			}
			if (_tmp163_) {
				ValaExpression* _tmp170_;
				ValaExpression* _tmp171_;
				ValaSymbol* _tmp172_;
				ValaSymbol* _tmp173_;
				ValaExpression* _tmp174_;
				ValaExpression* _tmp175_;
				ValaDataType* _tmp176_;
				ValaDataType* _tmp177_;
				index_int_type_check = FALSE;
				_tmp170_ = vala_element_access_get_container (self);
				_tmp171_ = _tmp170_;
				_tmp172_ = vala_expression_get_symbol_reference (_tmp171_);
				_tmp173_ = _tmp172_;
				vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp173_);
				_tmp174_ = vala_element_access_get_container (self);
				_tmp175_ = _tmp174_;
				_tmp176_ = vala_expression_get_value_type (_tmp175_);
				_tmp177_ = _tmp176_;
				vala_expression_set_value_type ((ValaExpression*) self, _tmp177_);
			} else {
				gboolean _tmp178_;
				gboolean _tmp179_;
				ValaSourceReference* _tmp234_;
				ValaSourceReference* _tmp235_;
				ValaExpression* _tmp236_;
				ValaExpression* _tmp237_;
				ValaDataType* _tmp238_;
				ValaDataType* _tmp239_;
				gchar* _tmp240_;
				gchar* _tmp241_;
				_tmp178_ = vala_expression_get_lvalue ((ValaExpression*) self);
				_tmp179_ = _tmp178_;
				if (_tmp179_) {
					ValaMethod* set_method = NULL;
					ValaExpression* _tmp180_;
					ValaExpression* _tmp181_;
					ValaDataType* _tmp182_;
					ValaDataType* _tmp183_;
					ValaSymbol* _tmp184_;
					ValaMethod* _tmp185_;
					ValaAssignment* assignment = NULL;
					ValaCodeNode* _tmp186_;
					ValaCodeNode* _tmp187_;
					gboolean _tmp188_ = FALSE;
					gboolean _tmp189_ = FALSE;
					ValaMethod* _tmp190_;
					_tmp180_ = vala_element_access_get_container (self);
					_tmp181_ = _tmp180_;
					_tmp182_ = vala_expression_get_value_type (_tmp181_);
					_tmp183_ = _tmp182_;
					_tmp184_ = vala_data_type_get_member (_tmp183_, "set");
					_tmp185_ = VALA_IS_METHOD (_tmp184_) ? ((ValaMethod*) _tmp184_) : NULL;
					if (_tmp185_ == NULL) {
						_vala_code_node_unref0 (_tmp184_);
					}
					set_method = _tmp185_;
					_tmp186_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
					_tmp187_ = _tmp186_;
					assignment = VALA_IS_ASSIGNMENT (_tmp187_) ? ((ValaAssignment*) _tmp187_) : NULL;
					_tmp190_ = set_method;
					if (_tmp190_ != NULL) {
						ValaMethod* _tmp191_;
						ValaDataType* _tmp192_;
						ValaDataType* _tmp193_;
						_tmp191_ = set_method;
						_tmp192_ = vala_callable_get_return_type ((ValaCallable*) _tmp191_);
						_tmp193_ = _tmp192_;
						_tmp189_ = VALA_IS_VOID_TYPE (_tmp193_);
					} else {
						_tmp189_ = FALSE;
					}
					if (_tmp189_) {
						ValaAssignment* _tmp194_;
						_tmp194_ = assignment;
						_tmp188_ = _tmp194_ != NULL;
					} else {
						_tmp188_ = FALSE;
					}
					if (_tmp188_) {
						gboolean _tmp195_;
						gboolean _tmp196_;
						_tmp195_ = vala_code_node_get_error ((ValaCodeNode*) self);
						_tmp196_ = _tmp195_;
						result = !_tmp196_;
						_vala_code_node_unref0 (set_method);
						return result;
					}
					_vala_code_node_unref0 (set_method);
				} else {
					ValaMethod* get_method = NULL;
					ValaExpression* _tmp197_;
					ValaExpression* _tmp198_;
					ValaDataType* _tmp199_;
					ValaDataType* _tmp200_;
					ValaSymbol* _tmp201_;
					ValaMethod* _tmp202_;
					ValaMethod* _tmp203_;
					_tmp197_ = vala_element_access_get_container (self);
					_tmp198_ = _tmp197_;
					_tmp199_ = vala_expression_get_value_type (_tmp198_);
					_tmp200_ = _tmp199_;
					_tmp201_ = vala_data_type_get_member (_tmp200_, "get");
					_tmp202_ = VALA_IS_METHOD (_tmp201_) ? ((ValaMethod*) _tmp201_) : NULL;
					if (_tmp202_ == NULL) {
						_vala_code_node_unref0 (_tmp201_);
					}
					get_method = _tmp202_;
					_tmp203_ = get_method;
					if (_tmp203_ != NULL) {
						ValaMethodCall* get_call = NULL;
						ValaExpression* _tmp204_;
						ValaExpression* _tmp205_;
						ValaSourceReference* _tmp206_;
						ValaSourceReference* _tmp207_;
						ValaMemberAccess* _tmp208_;
						ValaMemberAccess* _tmp209_;
						ValaSourceReference* _tmp210_;
						ValaSourceReference* _tmp211_;
						ValaMethodCall* _tmp212_;
						ValaMethodCall* _tmp213_;
						ValaMethodCall* _tmp224_;
						ValaDataType* _tmp225_;
						ValaDataType* _tmp226_;
						ValaMethodCall* _tmp227_;
						ValaDataType* _tmp228_;
						ValaDataType* _tmp229_;
						ValaCodeNode* _tmp230_;
						ValaCodeNode* _tmp231_;
						ValaMethodCall* _tmp232_;
						ValaMethodCall* _tmp233_;
						_tmp204_ = vala_element_access_get_container (self);
						_tmp205_ = _tmp204_;
						_tmp206_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp207_ = _tmp206_;
						_tmp208_ = vala_member_access_new (_tmp205_, "get", _tmp207_);
						_tmp209_ = _tmp208_;
						_tmp210_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp211_ = _tmp210_;
						_tmp212_ = vala_method_call_new ((ValaExpression*) _tmp209_, _tmp211_);
						_tmp213_ = _tmp212_;
						_vala_code_node_unref0 (_tmp209_);
						get_call = _tmp213_;
						{
							ValaList* _e_list = NULL;
							ValaList* _tmp214_;
							gint _e_size = 0;
							ValaList* _tmp215_;
							gint _tmp216_;
							gint _tmp217_;
							gint _e_index = 0;
							_tmp214_ = vala_element_access_get_indices (self);
							_e_list = _tmp214_;
							_tmp215_ = _e_list;
							_tmp216_ = vala_collection_get_size ((ValaCollection*) _tmp215_);
							_tmp217_ = _tmp216_;
							_e_size = _tmp217_;
							_e_index = -1;
							while (TRUE) {
								gint _tmp218_;
								gint _tmp219_;
								ValaExpression* e = NULL;
								ValaList* _tmp220_;
								gpointer _tmp221_;
								ValaMethodCall* _tmp222_;
								ValaExpression* _tmp223_;
								_e_index = _e_index + 1;
								_tmp218_ = _e_index;
								_tmp219_ = _e_size;
								if (!(_tmp218_ < _tmp219_)) {
									break;
								}
								_tmp220_ = _e_list;
								_tmp221_ = vala_list_get (_tmp220_, _e_index);
								e = (ValaExpression*) _tmp221_;
								_tmp222_ = get_call;
								_tmp223_ = e;
								vala_callable_expression_add_argument ((ValaCallableExpression*) _tmp222_, _tmp223_);
								_vala_code_node_unref0 (e);
							}
						}
						_tmp224_ = get_call;
						_tmp225_ = vala_expression_get_formal_target_type ((ValaExpression*) self);
						_tmp226_ = _tmp225_;
						vala_expression_set_formal_target_type ((ValaExpression*) _tmp224_, _tmp226_);
						_tmp227_ = get_call;
						_tmp228_ = vala_expression_get_target_type ((ValaExpression*) self);
						_tmp229_ = _tmp228_;
						vala_expression_set_target_type ((ValaExpression*) _tmp227_, _tmp229_);
						_tmp230_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
						_tmp231_ = _tmp230_;
						_tmp232_ = get_call;
						vala_code_node_replace_expression (_tmp231_, (ValaExpression*) self, (ValaExpression*) _tmp232_);
						_tmp233_ = get_call;
						result = vala_code_node_check ((ValaCodeNode*) _tmp233_, context);
						_vala_code_node_unref0 (get_call);
						_vala_code_node_unref0 (get_method);
						return result;
					}
					_vala_code_node_unref0 (get_method);
				}
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp234_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp235_ = _tmp234_;
				_tmp236_ = vala_element_access_get_container (self);
				_tmp237_ = _tmp236_;
				_tmp238_ = vala_expression_get_value_type (_tmp237_);
				_tmp239_ = _tmp238_;
				_tmp240_ = vala_code_node_to_string ((ValaCodeNode*) _tmp239_);
				_tmp241_ = _tmp240_;
				vala_report_error (_tmp235_, "The expression `%s' does not denote an array", _tmp241_);
				_g_free0 (_tmp241_);
				result = FALSE;
				return result;
			}
		}
	}
	if (index_int_type_check) {
		{
			ValaList* _e_list = NULL;
			ValaList* _tmp242_;
			gint _e_size = 0;
			ValaList* _tmp243_;
			gint _tmp244_;
			gint _tmp245_;
			gint _e_index = 0;
			_tmp242_ = vala_element_access_get_indices (self);
			_e_list = _tmp242_;
			_tmp243_ = _e_list;
			_tmp244_ = vala_collection_get_size ((ValaCollection*) _tmp243_);
			_tmp245_ = _tmp244_;
			_e_size = _tmp245_;
			_e_index = -1;
			while (TRUE) {
				gint _tmp246_;
				gint _tmp247_;
				ValaExpression* e = NULL;
				ValaList* _tmp248_;
				gpointer _tmp249_;
				ValaExpression* _tmp250_;
				ValaDataType* _tmp251_;
				ValaDataType* _tmp252_;
				gboolean _tmp253_ = FALSE;
				ValaExpression* _tmp254_;
				ValaDataType* _tmp255_;
				ValaDataType* _tmp256_;
				_e_index = _e_index + 1;
				_tmp246_ = _e_index;
				_tmp247_ = _e_size;
				if (!(_tmp246_ < _tmp247_)) {
					break;
				}
				_tmp248_ = _e_list;
				_tmp249_ = vala_list_get (_tmp248_, _e_index);
				e = (ValaExpression*) _tmp249_;
				_tmp250_ = e;
				_tmp251_ = vala_expression_get_value_type (_tmp250_);
				_tmp252_ = _tmp251_;
				if (_tmp252_ == NULL) {
					result = FALSE;
					_vala_code_node_unref0 (e);
					return result;
				}
				_tmp254_ = e;
				_tmp255_ = vala_expression_get_value_type (_tmp254_);
				_tmp256_ = _tmp255_;
				if (VALA_IS_INTEGER_TYPE (_tmp256_)) {
					_tmp253_ = TRUE;
				} else {
					ValaExpression* _tmp257_;
					ValaDataType* _tmp258_;
					ValaDataType* _tmp259_;
					_tmp257_ = e;
					_tmp258_ = vala_expression_get_value_type (_tmp257_);
					_tmp259_ = _tmp258_;
					_tmp253_ = VALA_IS_ENUM_VALUE_TYPE (_tmp259_);
				}
				if (!_tmp253_) {
					ValaExpression* _tmp260_;
					ValaSourceReference* _tmp261_;
					ValaSourceReference* _tmp262_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp260_ = e;
					_tmp261_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp260_);
					_tmp262_ = _tmp261_;
					vala_report_error (_tmp262_, "Expression of integer type expected");
				}
				_vala_code_node_unref0 (e);
			}
		}
	}
	_tmp263_ = vala_expression_get_value_type ((ValaExpression*) self);
	_tmp264_ = _tmp263_;
	vala_code_node_check ((ValaCodeNode*) _tmp264_, context);
	_tmp265_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp266_ = _tmp265_;
	result = !_tmp266_;
	return result;
}

static void
vala_element_access_real_emit (ValaCodeNode* base,
                               ValaCodeGenerator* codegen)
{
	ValaElementAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaElementAccess*) base;
	g_return_if_fail (codegen != NULL);
	_tmp0_ = vala_element_access_get_container (self);
	_tmp1_ = _tmp0_;
	vala_code_node_emit ((ValaCodeNode*) _tmp1_, codegen);
	{
		ValaList* _e_list = NULL;
		ValaList* _tmp2_;
		gint _e_size = 0;
		ValaList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _e_index = 0;
		_tmp2_ = self->priv->indices;
		_e_list = _tmp2_;
		_tmp3_ = _e_list;
		_tmp4_ = vala_collection_get_size ((ValaCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_e_size = _tmp5_;
		_e_index = -1;
		while (TRUE) {
			gint _tmp6_;
			gint _tmp7_;
			ValaExpression* e = NULL;
			ValaList* _tmp8_;
			gpointer _tmp9_;
			ValaExpression* _tmp10_;
			_e_index = _e_index + 1;
			_tmp6_ = _e_index;
			_tmp7_ = _e_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _e_list;
			_tmp9_ = vala_list_get (_tmp8_, _e_index);
			e = (ValaExpression*) _tmp9_;
			_tmp10_ = e;
			vala_code_node_emit ((ValaCodeNode*) _tmp10_, codegen);
			_vala_code_node_unref0 (e);
		}
	}
	vala_code_visitor_visit_element_access ((ValaCodeVisitor*) codegen, self);
	vala_code_visitor_visit_expression ((ValaCodeVisitor*) codegen, (ValaExpression*) self);
}

static void
vala_element_access_real_get_defined_variables (ValaCodeNode* base,
                                                ValaCollection* collection)
{
	ValaElementAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaElementAccess*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_element_access_get_container (self);
	_tmp1_ = _tmp0_;
	vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp1_, collection);
	{
		ValaList* _index_list = NULL;
		ValaList* _tmp2_;
		gint _index_size = 0;
		ValaList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _index_index = 0;
		_tmp2_ = self->priv->indices;
		_index_list = _tmp2_;
		_tmp3_ = _index_list;
		_tmp4_ = vala_collection_get_size ((ValaCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_index_size = _tmp5_;
		_index_index = -1;
		while (TRUE) {
			gint _tmp6_;
			gint _tmp7_;
			ValaExpression* index = NULL;
			ValaList* _tmp8_;
			gpointer _tmp9_;
			ValaExpression* _tmp10_;
			_index_index = _index_index + 1;
			_tmp6_ = _index_index;
			_tmp7_ = _index_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _index_list;
			_tmp9_ = vala_list_get (_tmp8_, _index_index);
			index = (ValaExpression*) _tmp9_;
			_tmp10_ = index;
			vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp10_, collection);
			_vala_code_node_unref0 (index);
		}
	}
}

static void
vala_element_access_real_get_used_variables (ValaCodeNode* base,
                                             ValaCollection* collection)
{
	ValaElementAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaElementAccess*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_element_access_get_container (self);
	_tmp1_ = _tmp0_;
	vala_code_node_get_used_variables ((ValaCodeNode*) _tmp1_, collection);
	{
		ValaList* _index_list = NULL;
		ValaList* _tmp2_;
		gint _index_size = 0;
		ValaList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _index_index = 0;
		_tmp2_ = self->priv->indices;
		_index_list = _tmp2_;
		_tmp3_ = _index_list;
		_tmp4_ = vala_collection_get_size ((ValaCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_index_size = _tmp5_;
		_index_index = -1;
		while (TRUE) {
			gint _tmp6_;
			gint _tmp7_;
			ValaExpression* index = NULL;
			ValaList* _tmp8_;
			gpointer _tmp9_;
			ValaExpression* _tmp10_;
			_index_index = _index_index + 1;
			_tmp6_ = _index_index;
			_tmp7_ = _index_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _index_list;
			_tmp9_ = vala_list_get (_tmp8_, _index_index);
			index = (ValaExpression*) _tmp9_;
			_tmp10_ = index;
			vala_code_node_get_used_variables ((ValaCodeNode*) _tmp10_, collection);
			_vala_code_node_unref0 (index);
		}
	}
}

static void
vala_element_access_class_init (ValaElementAccessClass * klass,
                                gpointer klass_data)
{
	vala_element_access_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_element_access_finalize;
	g_type_class_adjust_private_offset (klass, &ValaElementAccess_private_offset);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_element_access_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_element_access_real_accept_children;
	((ValaCodeNodeClass *) klass)->to_string = (gchar* (*) (ValaCodeNode*)) vala_element_access_real_to_string;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode*, ValaExpression*, ValaExpression*)) vala_element_access_real_replace_expression;
	((ValaExpressionClass *) klass)->is_pure = (gboolean (*) (ValaExpression*)) vala_element_access_real_is_pure;
	((ValaExpressionClass *) klass)->is_accessible = (gboolean (*) (ValaExpression*, ValaSymbol*)) vala_element_access_real_is_accessible;
	((ValaCodeNodeClass *) klass)->get_error_types = (void (*) (ValaCodeNode*, ValaCollection*, ValaSourceReference*)) vala_element_access_real_get_error_types;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_element_access_real_check;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode*, ValaCodeGenerator*)) vala_element_access_real_emit;
	((ValaCodeNodeClass *) klass)->get_defined_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_element_access_real_get_defined_variables;
	((ValaCodeNodeClass *) klass)->get_used_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_element_access_real_get_used_variables;
}

static void
vala_element_access_instance_init (ValaElementAccess * self,
                                   gpointer klass)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	self->priv = vala_element_access_get_instance_private (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_EXPRESSION, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->indices = (ValaList*) _tmp1_;
}

static void
vala_element_access_finalize (ValaCodeNode * obj)
{
	ValaElementAccess * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_ELEMENT_ACCESS, ValaElementAccess);
	_vala_iterable_unref0 (self->priv->indices);
	_vala_code_node_unref0 (self->priv->_container);
	VALA_CODE_NODE_CLASS (vala_element_access_parent_class)->finalize (obj);
}

/**
 * Represents an array access expression.
 *
 * {{{ foo[1,2] }}}
 */
static GType
vala_element_access_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaElementAccessClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_element_access_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaElementAccess), 0, (GInstanceInitFunc) vala_element_access_instance_init, NULL };
	GType vala_element_access_type_id;
	vala_element_access_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaElementAccess", &g_define_type_info, 0);
	ValaElementAccess_private_offset = g_type_add_instance_private (vala_element_access_type_id, sizeof (ValaElementAccessPrivate));
	return vala_element_access_type_id;
}

GType
vala_element_access_get_type (void)
{
	static volatile gsize vala_element_access_type_id__volatile = 0;
	if (g_once_init_enter (&vala_element_access_type_id__volatile)) {
		GType vala_element_access_type_id;
		vala_element_access_type_id = vala_element_access_get_type_once ();
		g_once_init_leave (&vala_element_access_type_id__volatile, vala_element_access_type_id);
	}
	return vala_element_access_type_id__volatile;
}

