import sys
import time
import usbtc08

print 'usbtc08 example program'
print '-----------------------'
print

r = usbtc08.usb_tc08_open_unit_async()
if not r:
    print >>sys.stderr, 'ERROR: failed to open unit'
    sys.exit(1)

r, handle, t = usbtc08.usb_tc08_open_unit_progress(0)
while r == usbtc08.USBTC08_PROGRESS_PENDING:
    time.sleep(0.2);
    r, handle, t = usbtc08.usb_tc08_open_unit_progress(0)

if ( r != usbtc08.USBTC08_PROGRESS_COMPLETE ) or ( handle <= 0 ):
    print >>sys.stderr, 'ERROR: no usb tc08 unit could be opened'
    sys.exit(2)


u = usbtc08.USBTC08_INFO()
u.size = usbtc08.sizeof_USBTC08_INFO

r = usbtc08.usb_tc08_get_unit_info(handle, u)

print 'Unit information:'
print 'Serial: %s \nCal date: %s' % (u.szSerial, u.szCalDate)
print

r = usbtc08.usb_tc08_set_channel(handle, 0, 'C')

for i in xrange(1,9):
    r &= usbtc08.usb_tc08_set_channel(handle, 1, 'J')

if not r:
    print >>sys.stderr, "ERROR: failed to configure channels"
    sys.exit(3)

print 'Enabled all channels, selected Type J thermocouple.'
print

temp = usbtc08.floats(9)
usbtc08.usb_tc08_get_single(handle, temp, usbtc08.USBTC08_UNITS_CENTIGRADE)

print 'CJC :%7.2f C' % temp[0]

for i in range(1,9):
    print 'Ch %i:%7.2f C' % (i, temp[i])

print
usbtc08.usb_tc08_close_unit(handle)
print 'Unit closed'

