/*
    Theseus - maximum likelihood superpositioning of macromolecular structures

    Copyright (C) 2004-2014 Douglas L. Theobald

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the:

    Free Software Foundation, Inc.,
    59 Temple Place, Suite 330,
    Boston, MA  02111-1307  USA

    -/_|:|_|_\-
*/

#ifndef PDBMALLOC_SEEN
#define PDBMALLOC_SEEN

#include "Cds.h"
#include "PDBCds.h"

Seq2PDB
*Seq2pdbInit(void);

void
Seq2pdbAlloc(Seq2PDB *seq2pdb, const int seqnum);

void
Seq2pdbDestroy(Seq2PDB **seq2pdb);

Algorithm
*AlgorithmInit(void);

void
AlgorithmDestroy(Algorithm *algo);

Statistics
*StatsInit(void);

CdsArray
*CdsArrayInit(void);

void
CdsArrayAllocNum(CdsArray *cdsA, const int cnum);

void
CdsArrayAllocLen(CdsArray *cdsA, const int vlen);

void
CdsArrayAlloc(CdsArray *cdsA, const int cnum, const int vlen);

void
CdsArraySetup(CdsArray *cdsA);

void
DistMatsAlloc(CdsArray *cdsA);

void
DistMatsDestroy(CdsArray *cdsA);

void
CovMatsDestroy(CdsArray *cdsA);

void
PCAAlloc(CdsArray *cdsA);

void
PCADestroy(CdsArray *cdsA);

void
CdsArrayDestroy(CdsArray **cdsA_ptr);

Cds
*CdsInit(void);

void
CdsAlloc(Cds *cds, const int vlen);

void
CdsSetup(Cds *cds);

void
CdsDestroy(Cds **cds_ptr);

PDBCdsArray
*PDBCdsArrayInit(void);

void
PDBCdsArrayAllocNum(PDBCdsArray *pdbA, const int cnum);

void
PDBCdsArrayAllocLen(PDBCdsArray *pdbA, const int vlen);

void
PDBCdsArrayAlloc(PDBCdsArray *pdbA, const int cnum, const int vlen);

void
PDBCdsArrayDestroy(PDBCdsArray **pdbA_ptr);

PDBCds
*PDBCdsInit(void);

void
PDBCdsAlloc(PDBCds *pdbcds, const int vlen);

void
PDBCdsDestroy(PDBCds **cds_ptr);

#endif
