/*
    Theseus - maximum likelihood superpositioning of macromolecular structures

    Copyright (C) 2004-2014 Douglas L. Theobald

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the:

    Free Software Foundation, Inc.,
    59 Temple Place, Suite 330,
    Boston, MA  02111-1307  USA

    -/_|:|_|_\-
*/

#ifndef PDBIO_SEEN
#define PDBIO_SEEN

#include "pdbMalloc.h"

int
ReadPDBCds(char *pdbfile_name, PDBCdsArray *pdbA, int cds_i, int modelnum, int amber, int fix_atom_names);

int
ReadTPSCds(char *pdbfile_name, PDBCdsArray *pdbA, int cds_i, int modelnum);

PDBCdsArray
*GetTPSCds(char **argv_array, int narguments);

void
GetCdsSelection(CdsArray *baseA, PDBCdsArray *pdbA);

PDBCdsArray
*GetPDBCds(char **argv_array, int narguments, int fmodel, int amber, int fix_atom_names);

void
PrintCds(Cds *cds);

void
PrintPDBCds(FILE *pdbfile, PDBCds *pdbcds);

void
WriteModelFile(PDBCdsArray *pdbA, char *outfile_name);

void
WriteTheseusTPSModelFile(PDBCdsArray *pdbA, char *outfile_name);

void
WriteAveTPSCdsFile(PDBCdsArray *pdbA, char *outfile_name);

void
WriteTheseusModelFile(PDBCdsArray *pdbA, Algorithm *algo, Statistics *stats, char *outfile_name);

void
WriteTheseusModelFileNoStats(PDBCdsArray *pdbA, Algorithm *algo, char *outfile_name);

void
WriteTheseusCdsModelFile(CdsArray *cdsA, char *outfile_name);

void
OverWriteTheseusCdsModelFile(CdsArray *cdsA, char *outfile_name);

void
WriteTheseusPDBFiles(PDBCdsArray *pdbA, Algorithm *algo, Statistics *stats);

void
WriteOlveModelFile(PDBCdsArray *pdbA, Algorithm *algo, Statistics *stats, char *outfile_name);

void
WriteCdsFile(Cds *cds, char *outfile_name);

void
WriteAveCdsFile(CdsArray *cdsA, char *outfile_name);

void
WriteAveCds(CdsArray *cdsA, char *outfile_name);

void
WriteAvePDBCdsFile(PDBCdsArray *pdbA, char *outfile_name);

void
WriteBinPDBCdsArray(PDBCdsArray *pdbA);

PDBCdsArray
*ReadBinPDBCdsArray(char *filename);

void
WriteBinPDBCds(PDBCds *pdbcds, FILE *fp);

void
ReadBinPDBCds(PDBCds *pdbcds, FILE *fp);

void
WriteBinMatrix(double **mat, int rows, int cols, FILE *fp);

void
ReadBinMatrix(double **mat, FILE *fp);

int
ConvertLele_freeform(char *fp_name, const int dim, const int forms, const int lmarks);

int
ConvertDryden(char *fp_name, const int dim, const int forms, const int lmarks);

int
ConvertLele(char *fp_name, const int dim, const int forms, const int lmarks);

void
WriteLeleModelFile(PDBCdsArray *pdbAr);

void
WriteInstModelFile(char *fext, CdsArray *cdsA);

void
WriteEdgarSSM(CdsArray *cdsA);

void
WriteOlveFiles(CdsArray *cdsA);

void
WriteDistMatTree(CdsArray *cdsA);

#endif
