'\"
'\" Generated from file 'plugin\&.inc' by tcllib/doctools with format 'nroff'
'\" Copyright (c) 2009 Andreas Kupries <andreas_kupries@users\&.sourceforge\&.net>
'\"
.TH "pt::peg::export::peg" n 1 tcllib "Parser Tools"
.\" The -*- nroff -*- definitions below are for supplemental macros used
.\" in Tcl/Tk manual entries.
.\"
.\" .AP type name in/out ?indent?
.\"	Start paragraph describing an argument to a library procedure.
.\"	type is type of argument (int, etc.), in/out is either "in", "out",
.\"	or "in/out" to describe whether procedure reads or modifies arg,
.\"	and indent is equivalent to second arg of .IP (shouldn't ever be
.\"	needed;  use .AS below instead)
.\"
.\" .AS ?type? ?name?
.\"	Give maximum sizes of arguments for setting tab stops.  Type and
.\"	name are examples of largest possible arguments that will be passed
.\"	to .AP later.  If args are omitted, default tab stops are used.
.\"
.\" .BS
.\"	Start box enclosure.  From here until next .BE, everything will be
.\"	enclosed in one large box.
.\"
.\" .BE
.\"	End of box enclosure.
.\"
.\" .CS
.\"	Begin code excerpt.
.\"
.\" .CE
.\"	End code excerpt.
.\"
.\" .VS ?version? ?br?
.\"	Begin vertical sidebar, for use in marking newly-changed parts
.\"	of man pages.  The first argument is ignored and used for recording
.\"	the version when the .VS was added, so that the sidebars can be
.\"	found and removed when they reach a certain age.  If another argument
.\"	is present, then a line break is forced before starting the sidebar.
.\"
.\" .VE
.\"	End of vertical sidebar.
.\"
.\" .DS
.\"	Begin an indented unfilled display.
.\"
.\" .DE
.\"	End of indented unfilled display.
.\"
.\" .SO ?manpage?
.\"	Start of list of standard options for a Tk widget. The manpage
.\"	argument defines where to look up the standard options; if
.\"	omitted, defaults to "options". The options follow on successive
.\"	lines, in three columns separated by tabs.
.\"
.\" .SE
.\"	End of list of standard options for a Tk widget.
.\"
.\" .OP cmdName dbName dbClass
.\"	Start of description of a specific option.  cmdName gives the
.\"	option's name as specified in the class command, dbName gives
.\"	the option's name in the option database, and dbClass gives
.\"	the option's class in the option database.
.\"
.\" .UL arg1 arg2
.\"	Print arg1 underlined, then print arg2 normally.
.\"
.\" .QW arg1 ?arg2?
.\"	Print arg1 in quotes, then arg2 normally (for trailing punctuation).
.\"
.\" .PQ arg1 ?arg2?
.\"	Print an open parenthesis, arg1 in quotes, then arg2 normally
.\"	(for trailing punctuation) and then a closing parenthesis.
.\"
.\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
.\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1 \\fI\\$2\\fP (\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
.\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
.\"	# BS - start boxed text
.\"	# ^y = starting y location
.\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
.\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
.\"	# VS - start vertical sidebar
.\"	# ^Y = starting y location
.\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
.\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
.\"	# Special macro to handle page bottom:  finish off current
.\"	# box/sidebar if in box/sidebar mode, then invoked standard
.\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
.\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
.\"	# DE - end display
.de DE
.fi
.RE
.sp
..
.\"	# SO - start of list of standard options
.de SO
'ie '\\$1'' .ds So \\fBoptions\\fR
'el .ds So \\fB\\$1\\fR
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 5.5c 11c
.ft B
..
.\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\*(So manual entry for details on the standard options.
..
.\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
.\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
.\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.\"	# UL - underline word
.de UL
\\$1\l'|0\(ul'\\$2
..
.\"	# QW - apply quotation marks to word
.de QW
.ie '\\*(lq'"' ``\\$1''\\$2
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\$2
..
.\"	# PQ - apply parens and quotation marks to word
.de PQ
.ie '\\*(lq'"' (``\\$1''\\$2)\\$3
.\"" fix emacs highlighting
.el (\\*(lq\\$1\\*(rq\\$2)\\$3
..
.\"	# QR - quoted range
.de QR
.ie '\\*(lq'"' ``\\$1''\\-``\\$2''\\$3
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\-\\*(lq\\$2\\*(rq\\$3
..
.\"	# MT - "empty" string
.de MT
.QW ""
..
.BS
.SH NAME
pt::peg::export::peg \- PEG Export Plugin\&. Write PEG format
.SH SYNOPSIS
package require \fBTcl  8\&.5\fR
.sp
package require \fBpt::peg::export::peg  ?1?\fR
.sp
package require \fBpt::peg::to::peg \fR
.sp
\fBexport\fR \fIserial\fR \fIconfiguration\fR
.sp
.BE
.SH DESCRIPTION
.PP
Are you lost ?
Do you have trouble understanding this document ?
In that case please read the overview provided by the
\fIIntroduction to Parser Tools\fR\&. This document is the
entrypoint to the whole system the current package is a part of\&.
.PP
This package implements the parsing expression grammar export plugin
for the generation of PEG markup\&.
.PP
It resides in the Export section of the Core Layer of Parser Tools and
is intended to be used by \fBpt::peg::export\fR, the export
manager, sitting between it and the corresponding core conversion
functionality provided by \fBpt::peg::to::peg\fR\&.
.PP
IMAGE: arch_core_eplugins
.PP
.PP
While the direct use of this package with a regular interpreter is
possible, this is strongly disrecommended and requires a number of
contortions to provide the expected environment\&.
The proper way to use this functionality depends on the situation:
.IP [1]
In an untrusted environment the proper access is through the package
\fBpt::peg::export\fR and the export manager objects it
provides\&.
.IP [2]
In a trusted environment however simply use the package
\fBpt::peg::to::peg\fR and access the core
conversion functionality directly\&.
.PP
.SH API
The API provided by this package satisfies the specification of the
Plugin API found in the \fIParser Tools Export API\fR
specification\&.
.TP
\fBexport\fR \fIserial\fR \fIconfiguration\fR
This command takes the canonical serialization of a parsing expression
grammar, as specified in section \fBPEG serialization format\fR,
and contained in \fIserial\fR, the \fIconfiguration\fR, a dictionary,
and generates PEG markup encoding the grammar\&.
The created string is then returned as the result of the command\&.
.PP
.SH CONFIGURATION
The PEG export plugin recognizes the following configuration
variables and changes its behaviour as they specify\&.
.TP
string \fItemplate\fR
If this configuration variable is set it is assumed to contain a
string into which to put the generated text and other configuration
data\&. The various locations are expected to be specified with the
following placeholders:
.RS
.TP
\fB@user@\fR
To be replaced with the value of the configuration variable \fBuser\fR\&.
.TP
\fB@format@\fR
To be replaced with the the constant \fBPEG\fR\&.
.TP
\fB@file@\fR
To be replaced with the value of the configuration variable \fBfile\fR\&.
.TP
\fB@name@\fR
To be replaced with the value of the configuration variable \fBname\fR\&.
.TP
\fB@code@\fR
To be replaced with the generated text\&.
.RE
.sp
If this configuration variable is not set, or empty, then the plugin
falls back to a standard template, which is defined as "\fB@code@\fR"\&.
.PP
\fINote\fR that this plugin may ignore the standard configuration
variables \fBuser\fR, \fBformat\fR, \fBfile\fR, and their values,
depending on the chosen template\&.
.PP
The content of the standard configuration variable \fBname\fR, if set,
is used as name of the grammar in the output\&. Otherwise the plugin
falls back to the default name \fBa_pe_grammar\fR\&.
.SH "PEG SPECIFICATION LANGUAGE"
\fBpeg\fR, a language for the specification of parsing expression
grammars is meant to be human readable, and writable as well, yet
strict enough to allow its processing by machine\&. Like any computer
language\&. It was defined to make writing the specification of a
grammar easy, something the other formats found in the Parser Tools do
not lend themselves too\&.
.PP
It is formally specified by the grammar shown below, written in
itself\&. For a tutorial / introduction to the language please go and
read the \fIPEG Language Tutorial\fR\&.
.PP
.CS


PEG pe-grammar-for-peg (Grammar)

	# --------------------------------------------------------------------
        # Syntactical constructs

        Grammar         <- WHITESPACE Header Definition* Final EOF ;

        Header          <- PEG Identifier StartExpr ;
        Definition      <- Attribute? Identifier IS Expression SEMICOLON ;
        Attribute       <- (VOID / LEAF) COLON ;
        Expression      <- Sequence (SLASH Sequence)* ;
        Sequence        <- Prefix+ ;
        Prefix          <- (AND / NOT)? Suffix ;
        Suffix          <- Primary (QUESTION / STAR / PLUS)? ;
        Primary         <- ALNUM / ALPHA / ASCII / CONTROL / DDIGIT / DIGIT
                        /  GRAPH / LOWER / PRINTABLE / PUNCT / SPACE / UPPER
                        /  WORDCHAR / XDIGIT
                        / Identifier
                        /  OPEN Expression CLOSE
                        /  Literal
                        /  Class
                        /  DOT
                        ;
        Literal         <- APOSTROPH  (!APOSTROPH  Char)* APOSTROPH  WHITESPACE
                        /  DAPOSTROPH (!DAPOSTROPH Char)* DAPOSTROPH WHITESPACE ;
        Class           <- OPENB (!CLOSEB Range)* CLOSEB WHITESPACE ;
        Range           <- Char TO Char / Char ;

        StartExpr       <- OPEN Expression CLOSE ;
void:   Final           <- END SEMICOLON WHITESPACE ;

        # --------------------------------------------------------------------
        # Lexing constructs

        Identifier      <- Ident WHITESPACE ;
leaf:   Ident           <- ('_' / ':' / <alpha>) ('_' / ':' / <alnum>)* ;
        Char            <- CharSpecial / CharOctalFull / CharOctalPart
                        /  CharUnicode / CharUnescaped
                        ;

leaf:   CharSpecial     <- "\\\\" [nrt'"\\[\\]\\\\] ;
leaf:   CharOctalFull   <- "\\\\" [0-2][0-7][0-7] ;
leaf:   CharOctalPart   <- "\\\\" [0-7][0-7]? ;
leaf:   CharUnicode     <- "\\\\" 'u' HexDigit (HexDigit (HexDigit HexDigit?)?)? ;
leaf:   CharUnescaped   <- !"\\\\" \&. ;

void:   HexDigit        <- [0-9a-fA-F] ;

void:   TO              <- '-'           ;
void:   OPENB           <- "["           ;
void:   CLOSEB          <- "]"           ;
void:   APOSTROPH       <- "'"           ;
void:   DAPOSTROPH      <- '"'           ;
void:   PEG             <- "PEG"   WHITESPACE ;
void:   IS              <- "<-"    WHITESPACE ;
leaf:   VOID            <- "void"  WHITESPACE ; # Implies that definition has no semantic value\&.
leaf:   LEAF            <- "leaf"  WHITESPACE ; # Implies that definition has no terminals\&.
void:   END             <- "END"   WHITESPACE ;
void:   SEMICOLON       <- ";"     WHITESPACE ;
void:   COLON           <- ":"     WHITESPACE ;
void:   SLASH           <- "/"     WHITESPACE ;
leaf:   AND             <- "&"     WHITESPACE ;
leaf:   NOT             <- "!"     WHITESPACE ;
leaf:   QUESTION        <- "?"     WHITESPACE ;
leaf:   STAR            <- "*"     WHITESPACE ;
leaf:   PLUS            <- "+"     WHITESPACE ;
void:   OPEN            <- "("     WHITESPACE ;
void:   CLOSE           <- ")"     WHITESPACE ;
leaf:   DOT             <- "\&."     WHITESPACE ;

leaf:   ALNUM           <- "<alnum>"    WHITESPACE ;
leaf:   ALPHA           <- "<alpha>"    WHITESPACE ;
leaf:   ASCII           <- "<ascii>"    WHITESPACE ;
leaf:   CONTROL         <- "<control>"  WHITESPACE ;
leaf:   DDIGIT          <- "<ddigit>"   WHITESPACE ;
leaf:   DIGIT           <- "<digit>"    WHITESPACE ;
leaf:   GRAPH           <- "<graph>"    WHITESPACE ;
leaf:   LOWER           <- "<lower>"    WHITESPACE ;
leaf:   PRINTABLE       <- "<print>"    WHITESPACE ;
leaf:   PUNCT           <- "<punct>"    WHITESPACE ;
leaf:   SPACE           <- "<space>"    WHITESPACE ;
leaf:   UPPER           <- "<upper>"    WHITESPACE ;
leaf:   WORDCHAR        <- "<wordchar>" WHITESPACE ;
leaf:   XDIGIT          <- "<xdigit>"   WHITESPACE ;

void:   WHITESPACE      <- (" " / "\\t" / EOL / COMMENT)* ;
void:   COMMENT         <- '#' (!EOL \&.)* EOL ;
void:   EOL             <- "\\n\\r" / "\\n" / "\\r" ;
void:   EOF             <- !\&. ;

        # --------------------------------------------------------------------
END;

.CE
.SS EXAMPLE
Our example specifies the grammar for a basic 4-operation calculator\&.
.PP
.CS


PEG calculator (Expression)
    Digit      <- '0'/'1'/'2'/'3'/'4'/'5'/'6'/'7'/'8'/'9'       ;
    Sign       <- '-' / '+'                                     ;
    Number     <- Sign? Digit+                                  ;
    Expression <- Term (AddOp Term)*                            ;
    MulOp      <- '*' / '/'                                     ;
    Term       <- Factor (MulOp Factor)*                        ;
    AddOp      <- '+'/'-'                                       ;
    Factor     <- '(' Expression ')' / Number                   ;
END;

.CE
.PP
Using higher-level features of the notation, i\&.e\&. the character
classes (predefined and custom), this example can be rewritten as
.PP
.CS


PEG calculator (Expression)
    Sign       <- [-+] 						;
    Number     <- Sign? <ddigit>+				;
    Expression <- '(' Expression ')' / (Factor (MulOp Factor)*)	;
    MulOp      <- [*/]						;
    Factor     <- Term (AddOp Term)*				;
    AddOp      <- [-+]						;
    Term       <- Number					;
END;

.CE
.PP
.SH "PEG SERIALIZATION FORMAT"
Here we specify the format used by the Parser Tools to serialize
Parsing Expression Grammars as immutable values for transport,
comparison, etc\&.
.PP
We distinguish between \fIregular\fR and \fIcanonical\fR
serializations\&.
While a PEG may have more than one regular serialization only exactly
one of them will be \fIcanonical\fR\&.
.TP
regular serialization
.RS
.IP [1]
The serialization of any PEG is a nested Tcl dictionary\&.
.IP [2]
This dictionary holds a single key, \fBpt::grammar::peg\fR, and its
value\&. This value holds the contents of the grammar\&.
.IP [3]
The contents of the grammar are a Tcl dictionary holding the set of
nonterminal symbols and the starting expression\&. The relevant keys and
their values are
.RS
.TP
\fBrules\fR
The value is a Tcl dictionary whose keys are the names of the
nonterminal symbols known to the grammar\&.
.RS
.IP [1]
Each nonterminal symbol may occur only once\&.
.IP [2]
The empty string is not a legal nonterminal symbol\&.
.IP [3]
The value for each symbol is a Tcl dictionary itself\&. The relevant
keys and their values in this dictionary are
.RS
.TP
\fBis\fR
The value is the serialization of the parsing expression describing
the symbols sentennial structure, as specified in the section
\fBPE serialization format\fR\&.
.TP
\fBmode\fR
The value can be one of three values specifying how a parser should
handle the semantic value produced by the symbol\&.
.RS
.TP
\fBvalue\fR
The semantic value of the nonterminal symbol is an abstract syntax
tree consisting of a single node node for the nonterminal itself,
which has the ASTs of the symbol's right hand side as its children\&.
.TP
\fBleaf\fR
The semantic value of the nonterminal symbol is an abstract syntax
tree consisting of a single node node for the nonterminal, without any
children\&. Any ASTs generated by the symbol's right hand side are
discarded\&.
.TP
\fBvoid\fR
The nonterminal has no semantic value\&. Any ASTs generated by the
symbol's right hand side are discarded (as well)\&.
.RE
.RE
.RE
.TP
\fBstart\fR
The value is the serialization of the start parsing expression of the
grammar, as specified in the section \fBPE serialization format\fR\&.
.RE
.IP [4]
The terminal symbols of the grammar are specified implicitly as the
set of all terminal symbols used in the start expression and on the
RHS of the grammar rules\&.
.RE
.TP
canonical serialization
The canonical serialization of a grammar has the format as specified
in the previous item, and then additionally satisfies the constraints
below, which make it unique among all the possible serializations of
this grammar\&.
.RS
.IP [1]
The keys found in all the nested Tcl dictionaries are sorted in
ascending dictionary order, as generated by Tcl's builtin command
\fBlsort -increasing -dict\fR\&.
.IP [2]
The string representation of the value is the canonical representation
of a Tcl dictionary\&. I\&.e\&. it does not contain superfluous whitespace\&.
.RE
.PP
.SS EXAMPLE
Assuming the following PEG for simple mathematical expressions
.PP
.CS


PEG calculator (Expression)
    Digit      <- '0'/'1'/'2'/'3'/'4'/'5'/'6'/'7'/'8'/'9'       ;
    Sign       <- '-' / '+'                                     ;
    Number     <- Sign? Digit+                                  ;
    Expression <- Term (AddOp Term)*                            ;
    MulOp      <- '*' / '/'                                     ;
    Term       <- Factor (MulOp Factor)*                        ;
    AddOp      <- '+'/'-'                                       ;
    Factor     <- '(' Expression ')' / Number                   ;
END;

.CE
.PP
then its canonical serialization (except for whitespace) is
.PP
.CS


pt::grammar::peg {
    rules {
        AddOp      {is {/ {t -} {t +}}                                                                mode value}
        Digit      {is {/ {t 0} {t 1} {t 2} {t 3} {t 4} {t 5} {t 6} {t 7} {t 8} {t 9}}                mode value}
        Expression {is {x {n Term} {* {x {n AddOp} {n Term}}}}                                        mode value}
        Factor     {is {/ {x {t (} {n Expression} {t )}} {n Number}}                                  mode value}
        MulOp      {is {/ {t *} {t /}}                                                                mode value}
        Number     {is {x {? {n Sign}} {+ {n Digit}}}                                                 mode value}
        Sign       {is {/ {t -} {t +}}                                                                mode value}
        Term       {is {x {n Factor} {* {x {n MulOp} {n Factor}}}}                                    mode value}
    }
    start {n Expression}
}

.CE
.PP
.SH "PE SERIALIZATION FORMAT"
Here we specify the format used by the Parser Tools to serialize
Parsing Expressions as immutable values for transport, comparison,
etc\&.
.PP
We distinguish between \fIregular\fR and \fIcanonical\fR
serializations\&.
While a parsing expression may have more than one regular
serialization only exactly one of them will be \fIcanonical\fR\&.
.TP
Regular serialization
.RS
.TP
\fBAtomic Parsing Expressions\fR
.RS
.IP [1]
The string \fBepsilon\fR is an atomic parsing expression\&. It matches
the empty string\&.
.IP [2]
The string \fBdot\fR is an atomic parsing expression\&. It matches
any character\&.
.IP [3]
The string \fBalnum\fR is an atomic parsing expression\&. It matches
any Unicode alphabet or digit character\&. This is a custom extension of
PEs based on Tcl's builtin command \fBstring is\fR\&.
.IP [4]
The string \fBalpha\fR is an atomic parsing expression\&. It matches
any Unicode alphabet character\&. This is a custom extension of PEs
based on Tcl's builtin command \fBstring is\fR\&.
.IP [5]
The string \fBascii\fR is an atomic parsing expression\&. It matches
any Unicode character below U0080\&. This is a custom extension of PEs
based on Tcl's builtin command \fBstring is\fR\&.
.IP [6]
The string \fBcontrol\fR is an atomic parsing expression\&. It matches
any Unicode control character\&. This is a custom extension of PEs based
on Tcl's builtin command \fBstring is\fR\&.
.IP [7]
The string \fBdigit\fR is an atomic parsing expression\&. It matches
any Unicode digit character\&. Note that this includes characters
outside of the [0\&.\&.9] range\&. This is a custom extension of PEs
based on Tcl's builtin command \fBstring is\fR\&.
.IP [8]
The string \fBgraph\fR is an atomic parsing expression\&. It matches
any Unicode printing character, except for space\&. This is a custom
extension of PEs based on Tcl's builtin command \fBstring is\fR\&.
.IP [9]
The string \fBlower\fR is an atomic parsing expression\&. It matches
any Unicode lower-case alphabet character\&. This is a custom extension
of PEs based on Tcl's builtin command \fBstring is\fR\&.
.IP [10]
The string \fBprint\fR is an atomic parsing expression\&. It matches
any Unicode printing character, including space\&. This is a custom
extension of PEs based on Tcl's builtin command \fBstring is\fR\&.
.IP [11]
The string \fBpunct\fR is an atomic parsing expression\&. It matches
any Unicode punctuation character\&. This is a custom extension of PEs
based on Tcl's builtin command \fBstring is\fR\&.
.IP [12]
The string \fBspace\fR is an atomic parsing expression\&. It matches
any Unicode space character\&. This is a custom extension of PEs based
on Tcl's builtin command \fBstring is\fR\&.
.IP [13]
The string \fBupper\fR is an atomic parsing expression\&. It matches
any Unicode upper-case alphabet character\&. This is a custom extension
of PEs based on Tcl's builtin command \fBstring is\fR\&.
.IP [14]
The string \fBwordchar\fR is an atomic parsing expression\&. It
matches any Unicode word character\&. This is any alphanumeric character
(see alnum), and any connector punctuation characters (e\&.g\&.
underscore)\&. This is a custom extension of PEs based on Tcl's builtin
command \fBstring is\fR\&.
.IP [15]
The string \fBxdigit\fR is an atomic parsing expression\&. It matches
any hexadecimal digit character\&. This is a custom extension of PEs
based on Tcl's builtin command \fBstring is\fR\&.
.IP [16]
The string \fBddigit\fR is an atomic parsing expression\&. It matches
any decimal digit character\&. This is a custom extension of PEs based
on Tcl's builtin command \fBregexp\fR\&.
.IP [17]
The expression
[list t \fBx\fR]
is an atomic parsing expression\&. It matches the terminal string \fBx\fR\&.
.IP [18]
The expression
[list n \fBA\fR]
is an atomic parsing expression\&. It matches the nonterminal \fBA\fR\&.
.RE
.TP
\fBCombined Parsing Expressions\fR
.RS
.IP [1]
For parsing expressions \fBe1\fR, \fBe2\fR, \&.\&.\&. the result of
[list / \fBe1\fR \fBe2\fR \&.\&.\&. ]
is a parsing expression as well\&.
This is the \fIordered choice\fR, aka \fIprioritized choice\fR\&.
.IP [2]
For parsing expressions \fBe1\fR, \fBe2\fR, \&.\&.\&. the result of
[list x \fBe1\fR \fBe2\fR \&.\&.\&. ]
is a parsing expression as well\&.
This is the \fIsequence\fR\&.
.IP [3]
For a parsing expression \fBe\fR the result of
[list * \fBe\fR]
is a parsing expression as well\&.
This is the \fIkleene closure\fR, describing zero or more
repetitions\&.
.IP [4]
For a parsing expression \fBe\fR the result of
[list + \fBe\fR]
is a parsing expression as well\&.
This is the \fIpositive kleene closure\fR, describing one or more
repetitions\&.
.IP [5]
For a parsing expression \fBe\fR the result of
[list & \fBe\fR]
is a parsing expression as well\&.
This is the \fIand lookahead predicate\fR\&.
.IP [6]
For a parsing expression \fBe\fR the result of
[list ! \fBe\fR]
is a parsing expression as well\&.
This is the \fInot lookahead predicate\fR\&.
.IP [7]
For a parsing expression \fBe\fR the result of
[list ? \fBe\fR]
is a parsing expression as well\&.
This is the \fIoptional input\fR\&.
.RE
.RE
.TP
Canonical serialization
The canonical serialization of a parsing expression has the format as
specified in the previous item, and then additionally satisfies the
constraints below, which make it unique among all the possible
serializations of this parsing expression\&.
.RS
.IP [1]
The string representation of the value is the canonical representation
of a pure Tcl list\&. I\&.e\&. it does not contain superfluous whitespace\&.
.IP [2]
Terminals are \fInot\fR encoded as ranges (where start and end of the
range are identical)\&.
.RE
.PP
.PP
.SS EXAMPLE
Assuming the parsing expression shown on the right-hand side of the
rule
.PP
.CS


    Expression <- Term (AddOp Term)*

.CE
.PP
then its canonical serialization (except for whitespace) is
.PP
.CS


    {x {n Term} {* {x {n AddOp} {n Term}}}}

.CE
.PP
.SH "BUGS, IDEAS, FEEDBACK"
This document, and the package it describes, will undoubtedly contain
bugs and other problems\&.
Please report such in the category \fIpt\fR of the
\fITcllib Trackers\fR [http://core\&.tcl\&.tk/tcllib/reportlist]\&.
Please also report any ideas for enhancements you may have for either
package and/or documentation\&.
.SH KEYWORDS
EBNF, LL(k), PEG, TDPL, context-free languages, export, expression, grammar, matching, parser, parsing expression, parsing expression grammar, plugin, push down automaton, recursive descent, serialization, state, top-down parsing languages, transducer
.SH CATEGORY
Parsing and Grammars
.SH COPYRIGHT
.nf
Copyright (c) 2009 Andreas Kupries <andreas_kupries@users\&.sourceforge\&.net>

.fi