/*
Copyright (c) 2003, Dinesh Nadarajah
All rights reserved.

Redistribution and use in source and binary forms, with or without modification, 
are permitted provided that the following conditions are met:

    * Redistributions of source code must retain the above copyright notice, 
      this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright notice, 
      this list of conditions and the following disclaimer in the documentation and/or 
      other materials provided with the distribution.
    * Neither the name of the author nor the names of its contributors 
      may be used to endorse or promote products derived from this software 
      without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED 
TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR 
CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, 
EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR 
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF 
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE 
OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

#include "anjal-uni.h"
#include <stdio.h>

static const GtkIMContextInfo tavp_uni_xim_info = { 
   "anjal-uni",	    /* ID */
   N_("Tamil-Anjal (UNICODE)"),   /* Human readable name */
   "gtk+",		    /* Translation domain */
   "",		    /* Dir for bindtextdomain (not strictly needed for "gtk+") */
   ""		            /* Languages for which this module is the default */
};

gint language = ENGLISH;
gint last_sent_keysym = 0;
guint32 last_sent_unicode = 0;
guint32 last_sent_base = 0;
guint32 last_sent_modi = 0;
gint soft_n = 0;

static const GtkIMContextInfo *info_list[] = {
  &tavp_uni_xim_info
};

GType type_tavp_uni = 0;

//-----------------------------------------------------------
void im_module_init (GTypeModule *type_module)
{
  gtk_im_context_tavp_uni_xim_register_type (type_module);
}

//-----------------------------------------------------------
void im_module_exit (void)
{
  gtk_im_context_tavp_uni_xim_shutdown ();
}

//-----------------------------------------------------------
void im_module_list (const GtkIMContextInfo ***contexts, int *n_contexts)
{
  *contexts = info_list;
  *n_contexts = G_N_ELEMENTS (info_list);
}

//-----------------------------------------------------------
GtkIMContext *im_module_create (const gchar *context_id)
{
  if (strcmp (context_id, "anjal-uni") == 0)
     return GTK_IM_CONTEXT(g_object_new (type_tavp_uni, NULL));
  else
     return NULL;
}

//-----------------------------------------------------------
void gtk_im_context_tavp_uni_xim_shutdown (void)
{
}

//------------------------------------------------------------
void gtk_im_context_tavp_uni_xim_register_type (GTypeModule *type_module)
{
  static const GTypeInfo im_context_tavp_uni_xim_info =
  {
    sizeof (GtkIMContextClass),
    (GBaseInitFunc) NULL,
    (GBaseFinalizeFunc) NULL,
    (GClassInitFunc) gtk_im_context_tavp_uni_xim_class_init,
    NULL,           /* class_finalize */    
    NULL,           /* class_data */
    sizeof (GtkIMContext),
    0,
    (GtkObjectInitFunc) gtk_im_context_tavp_uni_xim_init,
  };

  type_tavp_uni = 
    g_type_module_register_type (type_module,
				 GTK_TYPE_IM_CONTEXT,
				 "GtkIMContextTAVPUNI",
				 &im_context_tavp_uni_xim_info, 0);
}

//------------------------------------------------------------
void gtk_im_context_tavp_uni_xim_class_init (GtkIMContextClass *class)
{
  GtkIMContextClass *im_context_class = GTK_IM_CONTEXT_CLASS (class);

  //GObjectClass *gobject_class = G_OBJECT_CLASS (class);

  //parent_class = g_type_class_peek_parent (class);

  //im_context_class->set_client_window = gtk_im_context_xim_set_client_window;
  im_context_class->filter_keypress = gtk_im_context_tavp_uni_xim_filter_keypress;
  //im_context_class->reset = gtk_im_context_xim_reset;
  //im_context_class->get_preedit_string = gtk_im_context_xim_get_preedit_string;
  //im_context_class->focus_in = gtk_im_context_xim_focus_in;
  //im_context_class->focus_out = gtk_im_context_xim_focus_out;
  //im_context_class->set_cursor_location = gtk_im_context_xim_set_cursor_location;
  //im_context_class->set_use_preedit = gtk_im_context_xim_set_use_preedit;
  //gobject_class->finalize = gtk_im_context_xim_finalize;
}

//------------------------------------------------------------
void gtk_im_context_tavp_uni_xim_init (GtkIMContext *im_context_xim)
{
  //im_context_xim->use_preedit = FALSE;
  gtk_im_context_set_use_preedit(im_context_xim, FALSE);
}

//------------------------------------------------------------
gboolean gtk_im_context_tavp_uni_xim_filter_keypress (GtkIMContext *context,
				                    GdkEventKey  *event)
{
   if (event->type == GDK_KEY_PRESS) {
   
      if (event->keyval == GDK_BackSpace)
         set_state(0, 0);      

      if ((event->state & GDK_SHIFT_MASK) &&
         (event->keyval == GDK_Shift_L || event->keyval == GDK_Shift_R)) {
             // switch language codes
             language = !language;
             set_state(0, 0);
             return TRUE;
      }

      else if ((language == TAMIL &&
               event->keyval >= GDK_A && event->keyval <= GDK_z) 
               ||  event->keyval == GDK_minus) {
                  return process_unicode_tamilanjal(context, event);
      }

      else {
          guint32 u;
	       guchar utf8[16];
	      
          set_state(event->keyval, 0);
	       u = gdk_keyval_to_unicode(event->keyval);
	       if (u == 0) {
		        return FALSE;
	       }
	       utf8[g_unichar_to_utf8(u, utf8)] = '\0';
          g_signal_emit_by_name(context, "commit", utf8);
          last_sent_keysym = event->keyval;
          last_sent_unicode = u;

          return TRUE;
      }

   }
   
   return FALSE;
}

//----------------------------------------------------------------
void send_1_unicode_value(GtkIMContext *context, guint32 u1) {

   guchar utf8[16]; 
   
   utf8[g_unichar_to_utf8(u1, utf8)] = '\0';

   g_signal_emit_by_name(context, "commit", utf8);        
}

//----------------------------------------------------------------
void send_2_unicode_value(GtkIMContext *context, guint32 u1, guint32 u2) {

   guchar utf8[16]; 

   utf8[g_unichar_to_utf8(u1, utf8)] = '\0';
   g_signal_emit_by_name(context, "commit", utf8);  
   utf8[g_unichar_to_utf8(u2, utf8)] = '\0';
   g_signal_emit_by_name(context, "commit", utf8);        
}

//----------------------------------------------------------------
void send_3_unicode_value(GtkIMContext *context, guint32 u1, guint32 u2, guint32 u3) {

   guchar utf8[16]; 

   utf8[g_unichar_to_utf8(u1, utf8)] = '\0';
   g_signal_emit_by_name(context, "commit", utf8);  
   utf8[g_unichar_to_utf8(u2, utf8)] = '\0';
   g_signal_emit_by_name(context, "commit", utf8);
   utf8[g_unichar_to_utf8(u3, utf8)] = '\0';
   g_signal_emit_by_name(context, "commit", utf8);        
}

//----------------------------------------------------------------
void send_4_unicode_value(GtkIMContext *context, guint32 u1, guint32 u2, guint32 u3, guint32 u4) {

   guchar utf8[16]; 

   utf8[g_unichar_to_utf8(u1, utf8)] = '\0';
   g_signal_emit_by_name(context, "commit", utf8);  
   utf8[g_unichar_to_utf8(u2, utf8)] = '\0';
   g_signal_emit_by_name(context, "commit", utf8);
   utf8[g_unichar_to_utf8(u3, utf8)] = '\0';
   g_signal_emit_by_name(context, "commit", utf8);    
   utf8[g_unichar_to_utf8(u4, utf8)] = '\0';
   g_signal_emit_by_name(context, "commit", utf8);     
}

//----------------------------------------------------------------
gboolean process_unicode_tamilanjal(GtkIMContext *context, GdkEventKey *event) {

   guint32 u;
   
   switch (event->keyval) {

      case GDK_a:
         if (is_last_base_meyi() && last_sent_modi == 0xbcd) {
            gtk_im_context_delete_surrounding (context, -1, 1);
            set_state(last_sent_base, 0);
         }
         else if (is_last_base_meyi() && !last_sent_modi) {
            send_1_unicode_value(context, 0xbbe);
            set_state(last_sent_base, 0xbbe);
         }
         else if (last_sent_base == 0xb85) {
            gtk_im_context_delete_surrounding (context, -1, 1);
            send_1_unicode_value(context, 0xb86);
            set_state(0xb86, 0);
         }
         else {
            send_1_unicode_value(context, 0xb85);
            set_state(0xb85, 0);
         }
         break;
         
      case GDK_A:
         if (is_last_base_meyi() && last_sent_modi == 0xbcd) {
            gtk_im_context_delete_surrounding (context, -1, 1);
            send_1_unicode_value(context, 0xbbe);
            set_state(last_sent_base, 0xbbe);
         }         
         else {
            send_1_unicode_value(context, 0xb86);
            set_state(0xb86, 0);
         }
         break;
         
      case GDK_i:
         if (is_last_base_meyi() && last_sent_modi == 0xbcd) {
            gtk_im_context_delete_surrounding (context, -1, 1);
            send_1_unicode_value(context, 0xbbf);
            set_state(last_sent_base, 0xbbf);
         }
         else if (is_last_base_meyi() && last_sent_modi == 0xbbf) {
            gtk_im_context_delete_surrounding (context, -1, 1);
            send_1_unicode_value(context, 0xbc0);
            set_state(last_sent_base, 0xbc0);
         }
         else if (is_last_base_meyi() && !last_sent_modi) {
            send_1_unicode_value(context, 0xbc8);
            set_state(last_sent_base, 0xbc8);
         }
         else if (last_sent_base == 0xb87) {
            gtk_im_context_delete_surrounding (context, -1, 1);
            send_1_unicode_value(context, 0xb88);
            set_state(0xb88, 0);
         }
         else if (last_sent_base == 0xb85) {
            gtk_im_context_delete_surrounding (context, -1, 1);
            send_1_unicode_value(context, 0xb90);
            set_state(0xb90, 0);
         }
         else {
            send_1_unicode_value(context, 0xb87);
            set_state(0xb87, 0);
         }
         break;
         
      case GDK_I:
         if (is_last_base_meyi() && last_sent_modi == 0xbcd) {
            gtk_im_context_delete_surrounding (context, -1, 1);
            send_1_unicode_value(context, 0xbc0);
            set_state(last_sent_base, 0xbc0);
         }        
         else {
            send_1_unicode_value(context, 0xb88);
            set_state(0xb88, 0);
         }
         break;   

      case GDK_e:
         if (is_last_base_meyi() && last_sent_modi == 0xbcd) {
            gtk_im_context_delete_surrounding (context, -1, 1);
            send_1_unicode_value(context, 0xbc6);
            set_state(last_sent_base, 0xbc6);
         }
         else if (is_last_base_meyi() && last_sent_modi == 0xbc6) {
            gtk_im_context_delete_surrounding (context, -1, 1);
            send_1_unicode_value(context, 0xbc7);
            set_state(last_sent_base, 0xbc7);
         }
         else if (last_sent_base == 0xb8e) {
            gtk_im_context_delete_surrounding (context, -1, 1);
            send_1_unicode_value(context, 0xb8f);
            set_state(0xb8f, 0);
         }
         else {
            send_1_unicode_value(context, 0xb8e);
            set_state(0xb8e, 0);
         }
         break;
         
      case GDK_E:
         if (is_last_base_meyi() && last_sent_modi == 0xbcd) {
            gtk_im_context_delete_surrounding (context, -1, 1);
            send_1_unicode_value(context, 0xbc7);
            set_state(last_sent_base, 0xbc7);
         }         
         else {
            send_1_unicode_value(context, 0xb8f);
            set_state(0xb8f, 0);
         }
         break;   

      case GDK_o:
         if (is_last_base_meyi() && last_sent_modi == 0xbcd) {
            gtk_im_context_delete_surrounding (context, -1, 1);
            send_1_unicode_value(context, 0xbca);
            set_state(last_sent_base, 0xbca);
         }
         else if (is_last_base_meyi() && last_sent_modi == 0xbca) {
            gtk_im_context_delete_surrounding (context, -1, 1);
            send_1_unicode_value(context, 0xbcb);
            set_state(last_sent_base, 0xbcb);
         }
         else if (last_sent_base == 0xb92) {
            gtk_im_context_delete_surrounding (context, -1, 1);
            send_1_unicode_value(context, 0xb93);
            set_state(0xb93, 0);
         }
         else {
            send_1_unicode_value(context, 0xb92);
            set_state(0xb92, 0);
         }
         break;
         
      case GDK_O:
         if (is_last_base_meyi() && last_sent_modi == 0xbcd) {
            gtk_im_context_delete_surrounding (context, -1, 1);
            send_1_unicode_value(context, 0xbcb);
            set_state(last_sent_base, 0xbcb);
         }         
         else {
            send_1_unicode_value(context, 0xb93);
            set_state(0xb93, 0);
         }
         break;

      case GDK_u:
         if (is_last_base_meyi() && last_sent_modi == 0xbcd) {       
            gtk_im_context_delete_surrounding (context, -1, 1);
            send_1_unicode_value(context, 0xbc1);
            set_state(last_sent_base, 0xbc1);
         }
         else if (is_last_base_meyi() && !last_sent_modi) {
            send_1_unicode_value(context, 0xbcc);
            set_state(last_sent_base, 0xbcc);   
         }         
         else if (is_last_base_meyi() && last_sent_modi == 0xbc1) {
            gtk_im_context_delete_surrounding (context, -1, 1);
            send_1_unicode_value(context, 0xbc2);
            set_state(last_sent_base, 0xbc2);
         }
         else if (last_sent_base == 0xb85) {
            gtk_im_context_delete_surrounding (context, -1, 1);
            send_1_unicode_value(context, 0xb94);
            set_state(0xb94, 0);
         }         
         else if (last_sent_base == 0xb89) {
            gtk_im_context_delete_surrounding (context, -1, 1);
            send_1_unicode_value(context, 0xb8a);
            set_state(0xb8a, 0);
         }
         else {
            send_1_unicode_value(context, 0xb89);
            set_state(0xb89, 0);
         }
         break;
         
      case GDK_U:
         if (is_last_base_meyi() && last_sent_modi == 0xbcd) {
            gtk_im_context_delete_surrounding (context, -1, 1);
            send_1_unicode_value(context, 0xbc2);
            set_state(last_sent_base, 0xbc2);
         }         
         else {
            send_1_unicode_value(context, 0xb8a);
            set_state(0xb8a, 0);
         }
         break;

      case GDK_w:
         send_2_unicode_value(context, 0xba8, 0xbcd);
         set_state(0xba8, 0xbcd);
         break;
         
      case GDK_q:
         send_1_unicode_value(context, 0xb83);
         set_state(0xb83, 0);
         break;
                  
      case GDK_k:
         send_2_unicode_value(context, 0xb95, 0xbcd);
         set_state(0xb95, 0xbcd);
         break;

      case GDK_g:
         if (last_sent_base == 0xba9 && last_sent_modi == 0xbcd)
            gtk_im_context_delete_surrounding (context, -2, 2);
            
         send_2_unicode_value(context, 0xb99, 0xbcd);
         set_state(0xb99, 0xbcd);
         break;

      case GDK_c:
         send_2_unicode_value(context, 0xb9a, 0xbcd);
         set_state(0xb9a, 0xbcd);
         break;
         
      case GDK_t:
         send_2_unicode_value(context, 0xb9f, 0xbcd);
         set_state(0xb9f, 0xbcd);
         break;         

      case GDK_N:
         send_2_unicode_value(context, 0xba3, 0xbcd);
         set_state(0xba3, 0xbcd);
         break; 
         
      case GDK_d:
         send_2_unicode_value(context, 0xb9f, 0xbcd);
         set_state(0xb9f, 0xbcd);
         break;
         
      case GDK_b:
         send_2_unicode_value(context, 0xbaa, 0xbcd);
         set_state(0xbaa, 0xbcd);
         break;                  

      case GDK_p:
         send_2_unicode_value(context, 0xbaa, 0xbcd);
         set_state(0xbaa, 0xbcd);
         break;
         
      case GDK_m:
         send_2_unicode_value(context, 0xbae, 0xbcd);
         set_state(0xbae, 0xbcd);
         break;         

      case GDK_y:
         send_2_unicode_value(context, 0xbaf, 0xbcd);
         set_state(0xbaf, 0xbcd);
         break; 
         
      case GDK_r:
         if (last_sent_base == 0xb9a && last_sent_modi == 0xbcd) {
            gtk_im_context_delete_surrounding (context, -2, 2);      
            send_4_unicode_value(context, 0xbb8, 0xbcd, 0xbb0, 0xbc0);
            set_state(U_SHRI, 0);
         }
         else {      
            send_2_unicode_value(context, 0xbb0, 0xbcd);
            set_state(0xbb0, 0xbcd);
         }
         break;
         
      case GDK_l:
         send_2_unicode_value(context, 0xbb2, 0xbcd);
         set_state(0xbb2, 0xbcd);
         break; 
         
      case GDK_v:
         send_2_unicode_value(context, 0xbb5, 0xbcd);
         set_state(0xbb5, 0xbcd);
         break;         

      case GDK_z:
         send_2_unicode_value(context, 0xbb4, 0xbcd);
         set_state(0xbb4, 0xbcd);
         break; 
         
      case GDK_L:
         send_2_unicode_value(context, 0xbb3, 0xbcd);
         set_state(0xbb3, 0xbcd);
         break;
         
      case GDK_R:
         send_2_unicode_value(context, 0xbb1, 0xbcd);
         set_state(0xbb1, 0xbcd);
         break;          
         
      case GDK_n:
         send_2_unicode_value(context, 0xba9, 0xbcd);
         set_state(0xba9, 0xbcd);
         break;
         
      case GDK_x:
         send_4_unicode_value(context, 0xb95, 0xbcd, 0xbb7, 0xbcd);
         set_state(U_KSH, 0xbcd);
         break; 
         
      case GDK_j:
         if (last_sent_base == 0xba9 && last_sent_modi == 0xbcd) {
            gtk_im_context_delete_surrounding (context, -2, 2);      
            send_2_unicode_value(context, 0xb9e, 0xbcd);
            set_state(0xb9e, 0xbcd);
         }
         else {      
            send_2_unicode_value(context, 0xb9c, 0xbcd);
            set_state(0xb9c, 0xbcd);
         }
         break;         

      case GDK_S:
         send_2_unicode_value(context, 0xbb8, 0xbcd);
         set_state(0xbb8, 0xbcd);
         break; 
         
      case GDK_s:
         send_2_unicode_value(context, 0xb9a, 0xbcd);
         set_state(0xb9a, 0xbcd);
         break;
         
      case GDK_minus:
         if (last_sent_base == 0xba9 && last_sent_modi == 0xbcd) {
            gtk_im_context_delete_surrounding (context, -2, 2);
            send_2_unicode_value(context, 0xba8, 0xbcd);
            set_state(0xba8, 0xbcd);
         }
         else {
            u = gdk_keyval_to_unicode(event->keyval);
            if (u == 0) {
               return FALSE;
            }
            send_1_unicode_value(context, u);
            last_sent_keysym = event->keyval;
            last_sent_unicode = u;
            set_state(event->keyval, 0);
         }
         break;            
         
      case GDK_h:
         if (last_sent_base == 0xb9a && last_sent_modi == 0xbcd) {
            gtk_im_context_delete_surrounding (context, -2, 2);      
            send_2_unicode_value(context, 0xbb7, 0xbcd);
            set_state(0xbb7, 0xbcd);
         }
         else if (last_sent_base == 0xb9f && last_sent_modi == 0xbcd) {
            gtk_im_context_delete_surrounding (context, -2, 2);      
            send_2_unicode_value(context, 0xba4, 0xbcd);
            set_state(0xba4, 0xbcd);
         }
         else {
            send_2_unicode_value(context, 0xbb9, 0xbcd);
            set_state(0xbb9, 0xbcd);
         }
         break;          
     
      default:

         u = gdk_keyval_to_unicode(event->keyval);
         if (u == 0) {
            return FALSE;
         }
         send_1_unicode_value(context, u);
         last_sent_keysym = event->keyval;
         last_sent_unicode = u;
         set_state(event->keyval, 0);
         break;
   }
     
   return TRUE;
}

void set_state(guint32 base, guint32 modi) {
   last_sent_base = base;
   last_sent_modi = modi;
}

gboolean is_last_base_meyi(void) {
   if (last_sent_base >= 0xb95 && last_sent_base <= 0xbb9) {
      return TRUE;
   }
   else
      return FALSE;
}

void send_u(GtkIMContext *context) {
   send_1_unicode_value(context, 0xbc1);
        
   return;
}



