#!/bin/sh

set -e

HOOKS="/etc/dehydrated/hook.d"

deploy_challenge ()
{
	export DOMAIN="${1}" TOKEN_FILENAME="${2}" TOKEN_VALUE="${3}"

	run-parts --regex '^deploy_challenge.*' "${HOOKS}"
}

clean_challenge ()
{
	export DOMAIN="${1}" TOKEN_FILENAME="${2}" TOKEN_VALUE="${3}"

	run-parts --regex '^clean_challenge.*' "${HOOKS}"
}

sync_cert ()
{
	export KEYFILE="${1}" CERTFILE="${2}" FULLCHAINFILE="${3}" CHAINFILE="${4}" REQUESTFILE="${5}"

	run-parts --regex '^sync_cert.*' "${HOOKS}"
}

deploy_cert ()
{
	export DOMAIN="${1}" KEYFILE="${2}" CERTFILE="${3}" FULLCHAINFILE="${4}" CHAINFILE="${5}" TIMESTAMP="${6}"

	run-parts --regex '^deploy_cert.*' "${HOOKS}"
}

deploy_ocsp ()
{
	export DOMAIN="${1}" OCSPFILE="${2}" TIMESTAMP="${3}"

	run-parts --regex '^deploy_ocsp.*' "${HOOKS}"
}

unchanged_cert ()
{
	export DOMAIN="${1}" KEYFILE="${2}" CERTFILE="${3}" FULLCHAINFILE="${4}" CHAINFILE="${5}"

	run-parts --regex '^unchanged_cert.*' "${HOOKS}"
}

invalid_challenge ()
{
	export DOMAIN="${1}" RESPONSE="${2}"

	run-parts --regex '^invalid_challenge.*' "${HOOKS}"
}

request_failure ()
{
	export STATUSCODE="${1}" REASON="${2}" REQTYPE="${3}" HEADERS="${4}"

	run-parts --regex '^request_failure.*' "${HOOKS}"
}

generate_csr ()
{
	export DOMAIN="${1}" CERTDIR="${2}" ALTNAMES="${3}"

	run-parts --regex '^generate_csr.*' "${HOOKS}"
}

startup_hook ()
{
	run-parts --regex '^startup_hook.*' "${HOOKS}"
}

exit_hook ()
{
	export ERROR="${1:-}"

	run-parts --regex '^exit_hook.*' "${HOOKS}"
}

HANDLER="${1}"

if [ -z "${HANDLER}" ]
then
	echo "Usage: ${0} HANDLER" >&2
	exit 1
fi

shift

case "${HANDLER}" in
	deploy_challenge|clean_challenge|sync_cert|deploy_cert|deploy_ocsp|unchanged_cert|invalid_challenge|request_failure|generate_csr|startup_hook|exit_hook)
		"${HANDLER}" "${@}"
		;;
esac
