function test_failed=test_pconv
Lr=[9,10];

ctypes={'default','r','rr'};

test_failed=0;

disp(' ===============  TEST_PCONV ==============');

for jj=1:length(Lr)
  L=Lr(jj);
  for ii=1:3
    for type = {'real','complex'}
    ctype=ctypes{ii};
    
    if strcmp(type{1},'complex')
       f=tester_crand(L,1);
       g=tester_crand(L,1);
    else
       f=tester_rand(L,1);
       g=tester_rand(L,1);        
    end
    
    h1=pconv(f,g,ctype);
    h2=ref_pconv(f,g,ctype);
    
    res=norm(h1-h2);
    [test_failed,fail]=ltfatdiditfail(res,test_failed);        
    s=sprintf('PCONV %3s %6s  L:%3i %0.5g %s',ctype,type{1},L,res,fail);
    disp(s);
    end
  end;
end;



%-*- texinfo -*-
%@deftypefn {Function} test_pconv
%@verbatim
%@end verbatim
%@strong{Url}: @url{http://ltfat.sourceforge.net/doc/testing/test_pconv.php}
%@end deftypefn

% Copyright (C) 2005-2014 Peter L. Soendergaard <soender@users.sourceforge.net>.
% This file is part of LTFAT version 2.0.1
%
% This program is free software: you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation, either version 3 of the License, or
% (at your option) any later version.
%
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with this program.  If not, see <http://www.gnu.org/licenses/>.

