/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.vectorgraphics2d.util;

import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.Queue;

public class ImageDataStream
extends InputStream {
    private final BufferedImage image;
    private final int width;
    private final int height;
    private final Interleaving interleaving;
    private final Raster raster;
    private final boolean opaque;
    private final Queue<Integer> byteBuffer;
    private final int[] sampleValues;
    private final int[] sampleSizes;
    private int x;
    private int y;

    public ImageDataStream(BufferedImage bufferedImage, Interleaving interleaving) {
        this.image = bufferedImage;
        this.interleaving = interleaving;
        this.width = bufferedImage.getWidth();
        this.height = bufferedImage.getHeight();
        this.x = -1;
        this.y = 0;
        WritableRaster writableRaster = bufferedImage.getAlphaRaster();
        this.raster = interleaving == Interleaving.ALPHA_ONLY ? writableRaster : bufferedImage.getRaster();
        this.opaque = writableRaster == null;
        this.byteBuffer = new LinkedList<Integer>();
        this.sampleValues = new int[this.raster.getNumBands()];
        this.sampleSizes = this.raster.getSampleModel().getSampleSize();
    }

    public BufferedImage getImage() {
        return this.image;
    }

    public Interleaving getInterleaving() {
        return this.interleaving;
    }

    @Override
    public int read() throws IOException {
        if (!this.byteBuffer.isEmpty()) {
            return this.byteBuffer.poll();
        }
        if (!this.nextSample()) {
            return -1;
        }
        int n = this.sampleValues.length;
        if (this.interleaving == Interleaving.WITHOUT_ALPHA || this.interleaving == Interleaving.ALPHA_ONLY) {
            if (this.interleaving == Interleaving.WITHOUT_ALPHA && !this.opaque) {
                --n;
            }
            for (int i = 0; i < n; ++i) {
                this.bufferSampleValue(i);
            }
        } else if (this.opaque) {
            for (int i = 0; i < n; ++i) {
                this.bufferSampleValue(i);
            }
        } else {
            for (int i = 0; i < n; ++i) {
                if (i == 0) {
                    this.bufferSampleValue(n - 1);
                    continue;
                }
                this.bufferSampleValue(i - 1);
            }
        }
        if (!this.byteBuffer.isEmpty()) {
            return this.byteBuffer.poll();
        }
        return -1;
    }

    private void bufferSampleValue(int n) {
        if (this.sampleSizes[n] < 8) {
            int n2 = this.sampleValues[n] & 0xFF;
            this.byteBuffer.offer(n2);
        } else {
            int n3 = this.sampleSizes[n] / 8;
            for (int i = n3 - 1; i >= 0; --i) {
                int n4 = this.sampleValues[n] >> i * 8 & 0xFF;
                this.byteBuffer.offer(n4);
            }
        }
    }

    private boolean nextSample() {
        if (this.interleaving == Interleaving.SAMPLE || this.interleaving == Interleaving.WITHOUT_ALPHA) {
            ++this.x;
            if (this.x >= this.width) {
                this.x = 0;
                ++this.y;
            }
        }
        if (this.x < 0 || this.x >= this.width || this.y < 0 || this.y >= this.height) {
            return false;
        }
        this.raster.getPixel(this.x, this.y, this.sampleValues);
        return true;
    }

    public static enum Interleaving {
        SAMPLE,
        ROW,
        WITHOUT_ALPHA,
        ALPHA_ONLY;

    }
}

