<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet xmlns:xsl='http://www.w3.org/1999/XSL/Transform' version='1.0'>
    <xsl:output
        method="xml"
        indent="yes"
        standalone="yes"
        encoding="ISO-8859-1" />

        
    <!-- base document -->
   <xsl:template match="set" >
<document>
<head>
    <name url="allprojects.html">GroboUtils</name>
</head>
<body>

<P>
GroboUtils is a large package of various Java utilities.  It attempts to
have both JDK 1.1 and 1.2 compatiblity for most of the packages.
</P>
<P>Below is a partial catalog of what is contained:
</P>

<project-list>
    <xsl:apply-templates select="type" />
</project-list>

</body>
</document>
    </xsl:template>
    
    <xsl:template match="type" >
    <project-category>
        <xsl:attribute name="name"><xsl:value-of select="@name" /></xsl:attribute>
        
        <xsl:apply-templates />
    </project-category>
    </xsl:template>
    
    <xsl:template match="subproject">
        <subproject>
            <xsl:attribute name="project"><xsl:value-of select="@name" /></xsl:attribute>
            <xsl:attribute name="version"><xsl:value-of select="@version" /></xsl:attribute>
            
            <xsl:apply-templates />
        </subproject>
    </xsl:template>
    
    <xsl:template match="@*|node()" name="CopyWithTemplates">
        <xsl:copy>
            <xsl:apply-templates select="@*|node()" />
        </xsl:copy>
    </xsl:template>
</xsl:stylesheet>
