/*
 *  Copyright (C) 2005-2008  Maarten de Boer <maarten@resorama.com>
 * 
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  as published by the Free Software Foundation; either version 2
 *  of the License, or (at your option) any later version.
 * 
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 *  02110-1301, USA.
 * 
 */

#ifndef __Rect__
#define __Rect__

#include <vector>
#include <cmath>
#include "Point.hxx"
#include <cassert>

struct Rect
{
	float x, y, w, h;
	Rect()
			:x(0), y(0), w(0), h(0)
	{}
	Rect(float _x, float _y, float _w, float _h)
			:x(_x), y(_y), w(_w), h(_h)
	{}
	bool Contains(const Point& pt)
	{
		return pt.x >= x && pt.x <= x+w &&
			pt.y >= y && pt.y <= y+h;
	}
}
;

struct Polygon
{
	std::vector<Point> point;
	Polygon(int n):point(n)
	{
	}
	Polygon(const Polygon& p)
	:point(p.point)
	{
	}
	Polygon(const Rect& r)
	:point(4)
	{
		point[0].x = r.x;
		point[0].y = r.y;
		point[1].x = r.x + r.w;
		point[1].y = r.y;
		point[2].x = r.x + r.w;
		point[2].y = r.y + r.h;
		point[3].x = r.x;
		point[3].y = r.y + r.h;
	}
	Point& operator[] (unsigned int i)
	{
		assert(i < point.size());
		return point[i];
	}
	Point Center()
	{
		Point center;
		int n = 0;
		for (std::vector<Point>::const_iterator it = point.begin();
			it != point.end(); ++it)
		{	
			center += (*it);
			n++;
		}
		center /= 4;
		return center;
	}
	void Rotate(Point center,float angle)
	{
		for (std::vector<Point>::iterator it = point.begin();
			it != point.end(); ++it)
		{
			Point& pt = *it;
			Point dif = pt - center;
			dif.Rotate(angle);
			pt = center + dif;
		}
	}
	void Rotate(float angle)
	{
		Rotate(Center(),angle);
	}
	Polygon& operator += (const Point& d)
	{
		for (std::vector<Point>::iterator it = point.begin();
			it != point.end(); ++it)
		{
			Point& pt = *it;
			pt += d;
		}
		return *this;
	}
	Polygon& operator -= (const Point& d)
	{
		for (std::vector<Point>::iterator it = point.begin();
			it != point.end(); ++it)
		{
			Point& pt = *it;
			pt -= d;
		}
		return *this;
	}
};

#endif
