#ifndef ATL_sGetNB_geqrf

/*
 * NB selection for GEQRF: Side='RIGHT', Uplo='UPPER'
 * M : 25,160,240,320,720,880,960,1040,1120,1280,1360,1440,1520
 * N : 25,160,240,320,720,880,960,1040,1120,1280,1360,1440,1520
 * NB : 2,8,8,24,80,80,80,80,160,160,160,160,240
 */
#define ATL_sGetNB_geqrf(n_, nb_) \
{ \
   if ((n_) < 92) (nb_) = 2; \
   else if ((n_) < 280) (nb_) = 8; \
   else if ((n_) < 520) (nb_) = 24; \
   else if ((n_) < 1080) (nb_) = 80; \
   else if ((n_) < 1480) (nb_) = 160; \
   else (nb_) = 240; \
}


#endif    /* end ifndef ATL_sGetNB_geqrf */
