/*
 * Decompiled with CFR 0.152.
 */
package android.databinding.tool.expr;

import android.databinding.tool.expr.Dependency;
import android.databinding.tool.expr.Expr;
import android.databinding.tool.expr.StaticIdentifierExpr;
import android.databinding.tool.reflection.Callable;
import android.databinding.tool.reflection.ModelAnalyzer;
import android.databinding.tool.reflection.ModelClass;
import android.databinding.tool.reflection.ModelMethod;
import android.databinding.tool.util.L;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class MethodCallExpr
extends Expr {
    final String mName;
    Callable mGetter;

    MethodCallExpr(Expr target, String name, List<Expr> args) {
        super(Iterables.concat(Arrays.asList(target), args));
        this.mName = name;
    }

    @Override
    public void updateExpr(ModelAnalyzer modelAnalyzer) {
        this.resolveType(modelAnalyzer);
        super.updateExpr(modelAnalyzer);
    }

    @Override
    protected ModelClass resolveType(ModelAnalyzer modelAnalyzer) {
        if (this.mGetter == null) {
            ArrayList<ModelClass> args = new ArrayList<ModelClass>();
            for (Expr expr : this.getArgs()) {
                args.add(expr.getResolvedType());
            }
            Expr target = this.getTarget();
            boolean isStatic = target instanceof StaticIdentifierExpr;
            ModelMethod method = target.getResolvedType().getMethod(this.mName, args, isStatic);
            if (method == null) {
                String message = "cannot find method '" + this.mName + "' in class " + target.getResolvedType().toJavaCode();
                IllegalArgumentException e = new IllegalArgumentException(message);
                L.e(e, "cannot find method %s in class %s", this.mName, target.getResolvedType().toJavaCode());
                throw e;
            }
            int flags = 1;
            if (method.isStatic()) {
                flags |= 4;
            }
            this.mGetter = new Callable(Callable.Type.METHOD, method.getName(), method.getReturnType(args), flags);
        }
        return this.mGetter.resolvedType;
    }

    @Override
    protected List<Dependency> constructDependencies() {
        List<Dependency> dependencies = this.constructDynamicChildrenDependencies();
        for (Dependency dependency : dependencies) {
            if (dependency.getOther() != this.getTarget()) continue;
            dependency.setMandatory(true);
        }
        return dependencies;
    }

    @Override
    protected String computeUniqueKey() {
        return sUniqueKeyJoiner.join(this.getTarget().computeUniqueKey(), this.mName, super.computeUniqueKey());
    }

    public Expr getTarget() {
        return this.getChildren().get(0);
    }

    public String getName() {
        return this.mName;
    }

    public List<Expr> getArgs() {
        return this.getChildren().subList(1, this.getChildren().size());
    }

    public Callable getGetter() {
        return this.mGetter;
    }
}

