# F.1 Are "anarcho"-capitalists really anarchists?

In a word, no. While "anarcho"-capitalists obviously try to associate
themselves with the anarchist tradition by using the word "anarcho" or by
calling themselves "anarchists" their ideas are distinctly at odds with those
associated with anarchism. As a result, any claims that their ideas are
anarchist or that they are part of the anarchist tradition or movement are
false.

"Anarcho"-capitalists claim to be anarchists because they say that they oppose
government. As noted in the [last section](secFint.html), they use a
dictionary definition of anarchism. However, this fails to appreciate that
anarchism is a **political theory**. As dictionaries are rarely politically
sophisticated things, this means that they fail to recognise that anarchism is
more than just opposition to government, it is also marked a opposition to
capitalism (i.e. exploitation and private property). Thus, opposition to
government is a necessary but not sufficient condition for being an anarchist
-- you also need to be opposed to exploitation and capitalist private
property. As "anarcho"-capitalists do not consider interest, rent and profits
(i.e. capitalism) to be exploitative nor oppose capitalist property rights,
they are not anarchists.

Part of the problem is that Marxists, like many academics, also tend to assert
that anarchists are simply against the state. It is significant that both
Marxists and "anarcho"-capitalists tend to define anarchism as purely
opposition to government. This is no co-incidence, as both seek to exclude
anarchism from its place in the wider socialist movement. This makes perfect
sense from the Marxist perspective as it allows them to present their ideology
as the only serious anti-capitalist one around (not to mention associating
anarchism with "anarcho"-capitalism is an excellent way of discrediting our
ideas in the wider radical movement). It should go without saying that this is
an obvious and serious misrepresentation of the anarchist position as even a
superficial glance at anarchist theory and history shows that no anarchist
limited their critique of society simply at the state. So while academics and
Marxists seem aware of the anarchist opposition to the state, they usually
fail to grasp the anarchist critique applies to all other authoritarian social
institutions and how it fits into the overall anarchist analysis and struggle.
They seem to think the anarchist condemnation of capitalist private property,
patriarchy and so forth are somehow superfluous additions rather than a
logical position which reflects the core of anarchism:

> _ "Critics have sometimes contended that anarchist thought, and classical
anarchist theory in particular, has emphasised opposition to the state to the
point of neglecting the real hegemony of economic power. This interpretation
arises, perhaps, from a simplistic and overdrawn distinction between the
anarchist focus on political domination and the Marxist focus on economic
exploitation . . . there is abundant evidence against such a thesis throughout
the history of anarchist thought."_ [John P. Clark and Camille Martin,
**Anarchy, Geography, Modernity**, p. 95]

So Reclus simply stated the obvious when he wrote that _"the anti-
authoritarian critique to which the state is subjected applies equally to all
social institutions."_ [quoted by Clark and Martin, **Op. Cit.**, p. 140]
Proudhon, Bakunin, Kropotkin, Goldman and so on would all agree with that.
While they all stressed that anarchism was against the state they quickly
moved on to present a critique of private property and other forms of
hierarchical authority. So while anarchism obviously opposes the state,
_"sophisticated and developed anarchist theory proceeds further. It does not
stop with a criticism of political organisation, but goes on to investigate
the authoritarian nature of economic inequality and private property,
hierarchical economic structures, traditional education, the patriarchal
family, class and racial discrimination, and rigid sex- and age-roles, to
mention just a few of the more important topics."_ For the _"essence of
anarchism is, after all, not the theoretical opposition to the state, but the
practical and theoretical struggle against domination."_ [John Clark, **The
Anarchist Moment**, p. 128 and p. 70]

This is also the case with individualist anarchists whose defence of certain
forms of property did stop them criticising key aspects of **capitalist**
property rights. As Jeremy Jennings notes, the _"point to stress is that all
anarchists, and not only those wedded to the predominant twentieth-century
strain of anarchist communism have been critical of private property to the
extent that it was a source of hierarchy and privilege."_ He goes on to state
that anarchists like Tucker and Spooner _"agreed with the proposition that
property was legitimate only insofar as it embraced no more than the total
product of individual labour."_ [_"Anarchism"_, **Contemporary Political
Ideologies**, Roger Eatwell and Anthony Wright (eds.), p. 132] This is
acknowledged by the likes of Rothbard who had to explicitly point how that his
position on such subjects was fundamentally different (i.e., at odds) with
individualist anarchism.

As such, it would be fair to say that most "anarcho"-capitalists are
capitalists first and foremost. If aspects of anarchism do not fit with some
element of capitalism, they will reject that element of anarchism rather than
question capitalism (Rothbard's selective appropriation of the individualist
anarchist tradition is the most obvious example of this). This means that
right-"libertarians" attach the "anarcho" prefix to their ideology because
they believe that being against government intervention is equivalent to being
an anarchist (which flows into their use of the dictionary definition of
anarchism). That they ignore the bulk of the anarchist tradition should prove
that there is hardly anything anarchistic about them at all. They are not
against authority, hierarchy or the state -- they simply want to privatise
them.

Ironically, this limited definition of "anarchism" ensures that
"anarcho"-capitalism is inherently self-refuting. This can be seen from
leading "anarcho"-capitalist Murray Rothbard. He thundered against the evil of
the state, arguing that it _"arrogates to itself a monopoly of force, of
ultimate decision-making power, over a given territorial area."_ In and of
itself, this definition is unremarkable. That a few people (an elite of
rulers) claim the right to rule others must be **part** of any sensible
definition of the state or government. However, the problems begin for
Rothbard when he notes that _"[o]bviously, in a free society, Smith has the
ultimate decision-making power over his own just property, Jones over his,
etc."_ [**The Ethics of Liberty**, p. 170 and p. 173] The logical
contradiction in this position should be obvious, but not to Rothbard. It
shows the power of ideology, the ability of mere words (the expression
_"private property"_) to turn the bad (_"ultimate decision-making power over a
given area"_) into the good (_"ultimate decision-making power over a given
area"_).

Now, this contradiction can be solved in only **one** way -- the users of the
_"given area"_ are also its owners. In other words, a system of possession (or
"occupancy and use") as favoured by anarchists. However, Rothbard is a
capitalist and supports private property, non-labour income, wage labour,
capitalists and landlords. This means that he supports a divergence between
ownership and use and this means that this _"ultimate decision-making power"_
extends to those who **use,** but do not own, such property (i.e. tenants and
workers). The statist nature of private property is clearly indicated by
Rothbard's words -- the property owner in an "anarcho"-capitalist society
possesses the _"ultimate decision-making power"_ over a given area, which is
also what the state has currently. Rothbard has, ironically, proved by his own
definition that "anarcho"-capitalism is not anarchist.

Of course, it would be churlish to point out that the usual name for a
political system in which the owner of a territory is also its ruler is, in
fact, monarchy. Which suggests that while "anarcho"-capitalism may be called
"anarcho-statism" a far better term could be "anarcho-monarchism." In fact,
some "anarcho"-capitalists have made explicit this obvious implication of
Rothbard's argument. Hans-Hermann Hoppe is one.

Hoppe prefers monarchy to democracy, considering it the superior system. He
argues that the monarch is the **private** owner of the government -- all the
land and other resources are **owned** by him. Basing himself on Austrian
economics (what else?) and its notion of time preference, he concludes that
the monarch will, therefore, work to maximise both current income and the
total capital value of his estate. Assuming self-interest, his planning
horizon will be farsighted and exploitation be far more limited. Democracy, in
contrast, is a publicly-owned government and the elected rulers have use of
resources for a short period only and **not** their capital value. In other
words, they do not own the country and so will seek to maximise their short-
term interests (and the interests of those they think will elect them into
office). In contrast, Bakunin stressed that if anarchism rejects democracy it
was _"hardly in order to reverse it but rather to advance it,"_ in particular
to extend it via _"the great economic revolution without which every right is
but an empty phrase and a trick."_ He rejected wholeheartedly _"the camp of
aristocratic . . . reaction."_ [**The Basic Bakunin**, p. 87]

However, Hoppe is not a traditional monarchist. His ideal system is one of
**competing** monarchies, a society which is led by a _"voluntarily
acknowledged 'natural' elite -- a **nobilitas naturalis**"_ comprised of
_"families with long-established records of superior achievement,
farsightedness, and exemplary personal conduct."_ This is because _"a few
individuals quickly acquire the status of an elite"_ and their inherent
qualities will _"more likely than not [be] passed on within a few -- noble --
families."_ The sole "problem" with traditional monarchies was _"with
**monopoly**, not with elites or nobility,"_ in other words the King
monopolised the role of judge and their subjects could not turn to other
members of the noble class for services. [_"The Political Economy of Monarchy
and Democracy and the Idea of a Natural Order,"_ pp. 94-121, **Journal of
Libertarian Studies**, vol. 11, no. 2, p. 118 and p. 119]

Which simply confirms the anarchist critique of "anarcho"-capitalism, namely
that it is **not** anarchist. This becomes even more obvious when Hoppe
helpfully expands on the reality of "anarcho"-capitalism:

> _ "In a covenant concluded among proprietor and community tenants for the
purpose of protecting their private property, no such thing as a right to free
(unlimited) speech exists, not even to unlimited speech on one's own tenant-
property. One may say innumerable things and promote almost any idea under the
sun, but naturally no one is permitted to advocate ideas contrary to the very
purpose of the covenant of preserving private property, such as democracy and
communism. There can be no tolerance towards democrats and communists in a
libertarian social order. They will have to be physically separated and
expelled from society. Likewise in a covenant founded for the purpose of
protecting family and kin, there can be no tolerance toward those habitually
promoting lifestyles incompatible with this goal. They -- the advocates of
alternative, non-family and kin-centred lifestyles such as, for instance,
individual hedonism, parasitism, nature-environment worship, homosexuality, or
communism -- will have to be physically removed from society, too, if one is
to maintain a libertarian order."_ [**Democracy: the God that Failed**, p.
218]

Thus the proprietor has power/authority over his tenants and can decree what
they can and cannot do, excluding anyone whom they consider as being
subversive (in the tenants' own interests, of course). In other words, the
autocratic powers of the boss are extended into **all** aspects of society --
all under the mask of advocating liberty. Sadly, the preservation of property
rights destroys liberty for the many (Hoppe states clearly that for the
"anarcho"-capitalist the _"natural outcome of the voluntary transactions
between various private property owners is decidedly non-egalitarian,
hierarchical and elitist."_ [_"The Political Economy of Monarchy and Democracy
and the Idea of a Natural Order,"_ **Op. Cit.**, p. 118]). Unsurprisingly,
Chomsky argued that right-wing "libertarianism" has _"no objection to tyranny
as long as it is private tyranny."_ In fact it (like other contemporary
ideologies) _"reduce[s] to advocacy of one or another form of illegitimate
authority, quite often real tyranny."_ [**Chomsky on Anarchism**, p. 235 and
p. 181] As such, it is hard not to conclude that "anarcho"-capitalism is
little more than a play with words. It is not anarchism but a cleverly
designed and worded surrogate for elitist, autocratic conservatism. Nor is too
difficult to conclude that genuine anarchists and libertarians (of all types)
would not be tolerated in this so-called _"libertarian social order."_

Some "anarcho"-capitalists do seem dimly aware of this glaringly obvious
contradiction. Rothbard, for example, does present an argument which could be
used to solve it, but he utterly fails. He simply ignores the crux of the
matter, that capitalism is based on hierarchy and, therefore, cannot be
anarchist. He does this by arguing that the hierarchy associated with
capitalism is fine as long as the private property that produced it was
acquired in a "just" manner. Yet in so doing he yet again draws attention to
the identical authority structures and social relationships of the state and
property. As he puts it:

> _"**If** the State may be said to properly **own** its territory, then it is
proper for it to make rules for everyone who presumes to live in that area. It
can legitimately seize or control private property because there **is** no
private property in its area, because it really owns the entire land surface.
**So long** as the State permits its subjects to leave its territory, then, it
can be said to act as does any other owner who sets down rules for people
living on his property."_ [**Op. Cit.**, p. 170]

Obviously Rothbard argues that the state does not "justly" own its territory.
He asserts that _"our homesteading theory"_ of the creation of private
property _"suffices to demolish any such pretensions by the State apparatus"_
and so the problem with the state is that it _"claims and exercises a
compulsory monopoly of defence and ultimate decision-making over an area
larger than an individual's justly-acquired property."_ [**Op. Cit.**, p. 171
and p. 173] There are four fundamental problems with his argument.

First, it assumes his "homesteading theory" is a robust and libertarian
theory, but neither is the case (see [section F.4.1](secF4.html#secf41)).
Second, it ignores the history of capitalism. Given that the current
distribution of property is just as much the result of violence and coercion
as the state, his argument is seriously flawed. It amounts to little more than
an _**"immaculate conception of property"**_ unrelated to reality. Third, even
if we ignore these issues and assume that private property could be and was
legitimately produced by the means Rothbard assumes, it does not justify the
hierarchy associated with it as current and future generations of humanity
have, effectively, been excommunicated from liberty by previous ones. If, as
Rothbard argues, property is a natural right and the basis of liberty then why
should the many be excluded from their birthright by a minority? In other
words, Rothbard denies that liberty should be universal. He chooses property
over liberty while anarchists choose liberty over property. Fourthly, it
implies that the fundamental problem with the state is **not**, as anarchists
have continually stressed, its hierarchical and authoritarian nature but
rather the fact that it does not justly own the territory it claims to rule.

Even worse, the possibility that private property can result in **more**
violations of individual freedom (at least for non-proprietors ) than the
state of its citizens was implicitly acknowledged by Rothbard. He uses as a
hypothetical example a country whose King is threatened by a rising
"libertarian" movement. The King responses by _"employ[ing] a cunning
stratagem,"_ namely he _"proclaims his government to be dissolved, but just
before doing so he arbitrarily parcels out the entire land area of his kingdom
to the 'ownership' of himself and his relatives."_ Rather than taxes, his
subjects now pay rent and he can _"regulate the lives of all the people who
presume to live on"_ his property as he sees fit. Rothbard then asks:

> _"Now what should be the reply of the libertarian rebels to this pert
challenge? If they are consistent utilitarians, they must bow to this
subterfuge, and resign themselves to living under a regime no less despotic
than the one they had been battling for so long. Perhaps, indeed, **more**
despotic, for now the king and his relatives can claim for themselves the
libertarians' very principle of the absolute right of private property, an
absoluteness which they might not have dared to claim before."_ [**Op. Cit.**,
p. 54]

It should go without saying that Rothbard argues that we should reject this
_"cunning stratagem"_ as a con as the new distribution of property would not
be the result of "just" means. However, he failed to note how his argument
undermines his own claims that capitalism can be libertarian. As he himself
argues, not only does the property owner have the same monopoly of power over
a given area as the state, it is **more** despotic as it is based on the
_"absolute right of private property"_! And remember, Rothbard is arguing **in
favour** of "anarcho"-capitalism (_"if you have unbridled capitalism, you will
have all kinds of authority: you will have **extreme** authority."_ [Chomsky,
**Understanding Power**, p. 200]). The fundamental problem is that Rothbard's
ideology blinds him to the obvious, namely that the state and private property
produce identical social relationships (ironically, he opines the theory that
the state owns its territory _"makes the State, as well as the King in the
Middle Ages, a feudal overlord, who at least theoretically **owned** all the
land in his domain"_ without noticing that this makes the capitalist or
landlord a King and a feudal overlord within "anarcho"-capitalism. [**Op.
Cit.**, p. 171]).

One group of Chinese anarchists pointed out the obvious in 1914. As anarchism
_"takes opposition to authority as its essential principle,"_ anarchists aim
to _"sweep away all the evil systems of present society which have an
authoritarian nature"_ and so _"our ideal society"_ would be _"without
landlords, capitalists, leaders, officials, representatives or heads of
families."_ [quoted by Arif Dirlik, **Anarchism in the Chinese Revolution**,
p. 131] Only this, the elimination of all forms of hierarchy (political,
economic and social) would achieve genuine anarchism, a society without
authority (an-archy). In practice, private property is a major source of
oppression and authoritarianism within society -- there is little or no
freedom subject to a landlord or within capitalist production (as Bakunin
noted, _"the worker sells his person and his liberty for a given time"_). In
stark contrast to anarchists, "anarcho"-capitalists have no problem with
landlords and factory fascism (i.e. wage labour), a position which seems
highly illogical for a theory calling itself libertarian. If it were truly
libertarian, it would oppose all forms of domination, not just statism
(_"Those who reject authoritarianism will require nobody' permission to
breathe. The libertarian . . . is not grateful to get permission to reside
anywhere on his own planet and denies the right of any one to screen off bits
of it for their own use or rule."_ [Stuart Christie and Albert Meltzer,
**Floodgates of Anarchy**, p. 31]). This illogical and self-contradictory
position flows from the "anarcho"-capitalist definition of freedom as the
absence of coercion and will be discussed in [section F.2](secF2.html) in more
detail. The ironic thing is that "anarcho"-capitalists implicitly prove the
anarchist critique of their own ideology.

Of course, the "anarcho"-capitalist has another means to avoid the obvious,
namely the assertion that the market will limit the abuses of the property
owners. If workers do not like their ruler then they can seek another. Thus
capitalist hierarchy is fine as workers and tenants "consent" to it. While the
logic is obviously the same, it is doubtful that an "anarcho"-capitalist would
support the state just because its subjects can leave and join another one. As
such, this does not address the core issue -- the authoritarian nature of
capitalist property (see [section A.2.14](secA2.html#seca214)). Moreover, this
argument completely ignores the reality of economic and social power. Thus the
"consent" argument fails because it ignores the social circumstances of
capitalism which limit the choice of the many.

Anarchists have long argued that, as a class, workers have little choice but
to "consent" to capitalist hierarchy. The alternative is either dire poverty
or starvation. "Anarcho"-capitalists dismiss such claims by denying that there
is such a thing as economic power. Rather, it is simply freedom of contract.
Anarchists consider such claims as a joke. To show why, we need only quote
(yet again) Rothbard on the abolition of slavery and serfdom in the 19th
century. He argued, correctly, that the _"**bodies** of the oppressed were
freed, but the property which they had worked and eminently deserved to own,
remained in the hands of their former oppressors. With economic power thus
remaining in their hands, the former lords soon found themselves virtual
masters once more of what were now free tenants or farm labourers. The serfs
and slaves had tasted freedom, but had been cruelly derived of its fruits."_
[**Op. Cit.**, p. 74]

To say the least, anarchists fail to see the logic in this position. Contrast
this with the standard "anarcho"-capitalist claim that if market forces
("voluntary exchanges") result in the creation of _"tenants or farm
labourers"_ then they are free. Yet labourers dispossessed by market forces
are in exactly the same social and economic situation as the ex-serfs and ex-
slaves. If the latter do not have the fruits of freedom, neither do the
former. Rothbard sees the obvious _"economic power"_ in the latter case, but
denies it in the former (ironically, Rothbard dismissed economic power under
capitalism in the same work. [**Op. Cit.**, pp. 221-2]). It is only Rothbard's
ideology that stops him from drawing the obvious conclusion -- identical
economic conditions produce identical social relationships and so capitalism
is marked by _"economic power"_ and _"virtual masters."_ The only solution is
for "anarcho"-capitalist to simply say that the ex-serfs and ex-slaves were
actually free to choose and, consequently, Rothbard was wrong. It might be
inhuman, but at least it would be consistent!

Rothbard's perspective is alien to anarchism. For example, as individualist
anarchist William Bailie noted, under capitalism there is a class system
marked by _"a dependent industrial class of wage-workers"_ and _"a privileged
class of wealth-monopolisers, each becoming more and more distinct from the
other as capitalism advances."_ This has turned property into _"a social
power, an economic force destructive of rights, a fertile source of injustice,
a means of enslaving the dispossessed."_ He concluded: _"Under this system
equal liberty cannot obtain."_ Bailie notes that the modern _"industrial world
under capitalistic conditions"_ have _"arisen under the **regime** of status"_
(and so _"law-made privileges"_) however, it seems unlikely that he would have
concluded that such a class system would be fine if it had developed naturally
or the current state was abolished while leaving that class structure intact.
[**The Individualist Anarchists**, p. 121] As we discuss in [section
G.4](secG4.html), Individualist Anarchists like Tucker and Yarrows ended up
recognising that even the freest competition had become powerless against the
enormous concentrations of wealth associated with corporate capitalism.

Therefore anarchists recognise that "free exchange" or "consent" in unequal
circumstances will reduce freedom as well as increasing inequality between
individuals and classes. As we discuss in [section F.3](secF3.html),
inequality will produce social relationships which are based on hierarchy and
domination, **not** freedom. As Noam Chomsky put it:

> _"Anarcho-capitalism, in my opinion, is a doctrinal system which, if ever
implemented, would lead to forms of tyranny and oppression that have few
counterparts in human history. There isn't the slightest possibility that its
(in my view, horrendous) ideas would be implemented, because they would
quickly destroy any society that made this colossal error. The idea of 'free
contract' between the potentate and his starving subject is a sick joke,
perhaps worth some moments in an academic seminar exploring the consequences
of (in my view, absurd) ideas, but nowhere else."_ [**Noam Chomsky on
Anarchism**, interview with Tom Lane, December 23, 1996]

Clearly, then, by its own arguments "anarcho"-capitalism is not anarchist.
This should come as no surprise to anarchists. Anarchism, as a political
theory, was born when Proudhon wrote **What is Property?** specifically to
refute the notion that workers are free when capitalist property forces them
to seek employment by landlords and capitalists. He was well aware that in
such circumstances property _"violates equality by the rights of exclusion and
increase, and freedom by despotism . . . [and has] perfect identity with
robbery."_ He, unsurprisingly, talks of the _"proprietor, to whom [the worker]
has sold and surrendered his liberty."_ For Proudhon, anarchy was _"the
absence of a master, of a sovereign"_ while _"proprietor"_ was _"synonymous"_
with _"sovereign"_ for he _"imposes his will as law, and suffers neither
contradiction nor control."_ This meant that _"property engenders despotism,"_
as _"each proprietor is sovereign lord within the sphere of his property."_
[**What is Property**, p. 251, p. 130, p. 264 and pp. 266-7] It must also be
stressed that Proudhon's classic work is a lengthy critique of the kind of
apologetics for private property Rothbard espouses to salvage his ideology
from its obvious contradictions.

So, ironically, Rothbard repeats the same analysis as Proudhon but draws the
**opposite** conclusions and expects to be considered an anarchist! Moreover,
it seems equally ironic that "anarcho"-capitalism calls itself "anarchist"
while basing itself on the arguments that anarchism was created in opposition
to. As shown, "anarcho"-capitalism makes as much sense as "anarcho-statism" --
an oxymoron, a contradiction in terms. The idea that "anarcho"-capitalism
warrants the name "anarchist" is simply false. Only someone ignorant of
anarchism could maintain such a thing. While you expect anarchist theory to
show this to be the case, the wonderful thing is that "anarcho"-capitalism
itself does the same.

Little wonder Bob Black argues that _"[t]o demonise state authoritarianism
while ignoring identical albeit contract-consecrated subservient arrangements
in the large-scale corporations which control the world economy is fetishism
at its worst."_ [_"The Libertarian As Conservative"_, **The Abolition of Work
and Other Essays**, pp. 142] Left-liberal Stephen L. Newman makes the same
point:

> _ "The emphasis [right-wing] libertarians place on the opposition of liberty
and political power tends to obscure the role of authority in their worldview
. . . the authority exercised in private relationships, however -- in the
relationship between employer and employee, for instance -- meets with no
objection. . . . [This] reveals a curious insensitivity to the use of private
authority as a means of social control. Comparing public and private
authority, we might well ask of the [right-wing] libertarians: When the price
of exercising one's freedom is terribly high, what practical difference is
there between the commands of the state and those issued by one's employer? .
. . Though admittedly the circumstances are not identical, telling disgruntled
empowers that they are always free to leave their jobs seems no different in
principle from telling political dissidents that they are free to emigrate."_
[**Liberalism at Wit's End**, pp. 45-46]

As Bob Black pointed out, right libertarians argue that _"'one can at least
change jobs.' But you can't avoid having a job -- just as under statism one
can at least change nationalities but you can't avoid subjection to one
nation-state or another. But freedom means more than the right to change
masters."_ [**Op. Cit.**, p. 147] The similarities between capitalism and
statism are clear -- and so why "anarcho"-capitalism cannot be anarchist. To
reject the authority (the _"ultimate decision-making power"_) of the state and
embrace that of the property owner indicates not only a highly illogical
stance but one at odds with the basic principles of anarchism. This whole-
hearted support for wage labour and capitalist property rights indicates that
"anarcho"-capitalists are not anarchists because they do not reject all forms
of **archy.** They obviously support the hierarchy between boss and worker
(wage labour) and landlord and tenant. Anarchism, by definition, is against
all forms of archy, including the hierarchy generated by capitalist property.
To ignore the obvious archy associated with capitalist property is highly
illogical and trying to dismiss one form of domination as flowing from "just"
property while attacking the other because it flows from "unjust" property is
not seeing the wood for the trees.

In addition, we must note that such inequalities in power and wealth will need
"defending" from those subject to them ("anarcho"-capitalists recognise the
need for private police and courts to defend property from theft -- and,
anarchists add, to defend the theft and despotism associated with property!).
Due to its support of private property (and thus authority),
"anarcho"-capitalism ends up retaining a state in its "anarchy": namely a
**private** state whose existence its proponents attempt to deny simply by
refusing to call it a state, like an ostrich hiding its head in the sand. As
one anarchist so rightly put it, "anarcho"-capitalists _"simply replaced the
state with private security firms, and can hardly be described as anarchists
as the term is normally understood."_ [Brian Morris, _"Global Anti-
Capitalism"_, pp. 170-6, **Anarchist Studies**, vol. 14, no. 2, p. 175] As we
discuss more fully in [section F.6](secF6.html) this is why
"anarcho"-capitalism is better described as "private state" capitalism as
there would be a functional equivalent of the state and it would be just as
skewed in favour of the propertied elite as the existing one (if not more so).
As Albert Meltzer put it:

> _"Commonsense shows that any capitalist society might dispense with a
'State' . . . but it could not dispense with organised government, or a
privatised form of it, if there were people amassing money and others working
to amass it for them. The philosophy of 'anarcho-capitalism' dreamed up by the
'libertarian' New Right, has nothing to do with Anarchism as known by the
Anarchist movement proper. It is a lie . . . Patently unbridled capitalism . .
. needs some force at its disposal to maintain class privileges, either from
the State itself or from private armies. What they believe in is in fact a
limited State -- that is, one in which the State has one function, to protect
the ruling class, does not interfere with exploitation, and comes as cheap as
possible for the ruling class. The idea also serves another purpose . . . a
moral justification for bourgeois consciences in avoiding taxes without
feeling guilty about it."_ [**Anarchism: Arguments For and Against**, p. 50]

For anarchists, this need of capitalism for some kind of state is
unsurprising. For _"Anarchy without socialism seems equally as impossible to
us [as socialism without anarchy], for in such a case it could not be other
than the domination of the strongest, and would therefore set in motion right
away the organisation and consolidation of this domination; that is to the
constitution of government."_ [Errico Malatesta, **Errico Malatesta: His Life
and Ideas**, p. 148] Because of this, the "anarcho"-capitalist rejection of
the anarchist critique of capitalism and our arguments on the need for
equality, they cannot be considered anarchists or part of the anarchist
tradition. To anarchists it seems bizarre that "anarcho"-capitalists want to
get rid of the state but maintain the system it helped create and its function
as a defender of the capitalist class's property and property rights. In other
words, to reduce the state purely to its function as (to use Malatesta's apt
word) the gendarme of the capitalist class is **_not_** an anarchist goal.

Thus anarchism is far more than the common dictionary definition of "no
government" -- it also entails being against all forms of **archy**, including
those generated by capitalist property. This is clear from the roots of the
word "anarchy." As we noted in [section A.1](secA1.html), the word anarchy
means "no rulers" or "contrary to authority." As Rothbard himself
acknowledges, the property owner is the ruler of their property and,
therefore, those who use it. For this reason "anarcho"-capitalism cannot be
considered as a form of anarchism -- a real anarchist must logically oppose
the authority of the property owner along with that of the state. As
"anarcho"-capitalism does not explicitly (or implicitly, for that matter) call
for economic arrangements that will end wage labour and usury it cannot be
considered anarchist or part of the anarchist tradition. While anarchists have
always opposed capitalism, "anarcho"-capitalists have embraced it and due to
this embrace their "anarchy" will be marked by relationships based upon
subordination and hierarchy (such as wage labour), **not** freedom (little
wonder that Proudhon argued that _"property is despotism"_ \-- it creates
authoritarian and hierarchical relationships between people in a similar way
to statism). Their support for "free market" capitalism ignores the impact of
wealth and power on the nature and outcome of individual decisions within the
market (see sections [F.2](secF2.html) and [F.3](secF3.html) for further
discussion). Furthermore, any such system of (economic and social) power will
require extensive force to maintain it and the "anarcho"-capitalist system of
competing "defence firms" will simply be a new state, enforcing capitalist
power, property rights and law.

Thus the "anarcho"-capitalist and the anarchist have different starting
positions and opposite ends in mind. Their claims to being anarchists are
bogus simply because they reject so much of the anarchist tradition as to make
what little they do pay lip-service to non-anarchist in theory and practice.
Little wonder Peter Marshall said that _"few anarchists would accept the
'anarcho-capitalists' into the anarchist camp since they do not share a
concern for economic equality and social justice."_ As such,
"anarcho"-capitalists, _"even if they do reject the State, might therefore
best be called right-wing libertarians rather than anarchists."_ [**Demanding
the Impossible**, p. 565]

[‹ F.0 Section F Introduction](/afaq/secFint.html "Go to previous page" )
[up](/afaq/secFcon.html "Go to parent page" ) [F.2 What do
"anarcho"-capitalists mean by freedom? ›](/afaq/secF2.html "Go to next page" )

