/*
 *  Copyright (c) 1994, Riley Rainey,  riley@netcon.com
 *
 *  Permission to use, copy, modify and distribute (without charge) this
 *  software, documentation, images, etc. is granted, provided that this 
 *  comment and the author's name is retained.
 *
 *  This software is provided by the author as is, and without any expressed
 *  or implied warranties, including, but not limited to, the implied
 *  warranties of merchantability and fitness for a particular purpose.  In no
 *  event shall the author be liable for any direct, indirect, incidental, or
 *  consequential damages arising in any way out of the use of this software.
 */

#ifndef shared_H
#define shared_H

#include <X11/Intrinsic.h>

#include "../V/Vlibmath.h"

#ifdef shared_IMPORT
	#define EXTERN
#else
	#define EXTERN extern
#endif


/*
 *  Application resources
 */

typedef struct {
	char            *name;          /* pushbutton's name */
	XtCallbackProc  callback;       /* activate callback */
	XtPointer       client_data;    /* data to register for callback */
	}               ActionAreaButton;
	

typedef struct {
	Pixel   select_pixel;
	Pixel   grid_pixel;
	int     line_thickness;
	int     selection_thickness;
	int     box_size;
	int     box_offset;             /* half of box_size */
	int     pick_sensitivity;
	int     button_size;
	Pixel   cursor_foreground;
	Pixel   cursor_background;
	Boolean show_grid;
	Boolean show_ruler;
	XFontStruct     *ruler_font;
	}       AppData, *AppDataPtr;

#define XtNselectionColor       "selectionColor"
#define XtCSelectionColor       "SelectionColor"
#define XtNgridColor            "gridColor"
#define XtCGridColor            "GridColor"
#define XtNlineThickness        "lineThickness"
#define XtCLineThickness        "LineThickness"
#define XtNselectionThickness   "selectionThickness"
#define XtCSelectionThickness   "SelectionThickness"
#define XtNboxSize              "boxSize"
#define XtCBoxSize              "BoxSize"
#define XtNpickSensitivity      "pickSensitivity"
#define XtCPickSensitivity      "PickSensitivity"
#define XtNbuttonSize           "buttonSize"
#define XtCButtonSize           "ButtonSize"
#define XtNcursorForeground     "cursorColor"
#define XtCCursorForeground     "CursorColor"
#define XtNcursorBackground     "cursorBackgroundColor"
#define XtCCursorBackground     "CursorBackgroundColor"
#define XtNshowGrid             "showGrid"
#define XtCShowGrid             "ShowGrid"
#define XtNshowRuler            "showRuler"
#define XtCShowRuler            "ShowRuler"
#define XtNrulerFont            "rulerFont"

/*
 *  Menu dialog identification codes
 */

#define MENU_SET_VIEWS          1
#define MENU_COPY               2
#define MENU_CUT                3
#define MENU_PASTE              4
#define MENU_MIRROR_XZ          5
#define MENU_MIRROR_XY          6
#define MENU_MIRROR_YZ          7
#define MENU_CLEAR              8
#define MENU_SAVE               9
#define MENU_SAVE_AS            10
#define MENU_OPEN               11
#define MENU_NEW                12
#define MENU_GRID               13
#define MENU_RULER              14
#define MENU_SET_VIEWS_COMPLETE 15
#define MENU_SET_VIEWS_CANCEL   16
#define MENU_RESCALE_APPLY      17
#define MENU_RESCALE_CANCEL     18
#define MENU_RESCALE            19
#define MENU_MARKER             20      /* 32 markers are available */
#define MENU_MARKER_LAST        51      /* This is the highest marker */
#define MENU_GEAR_CALCULATE     52
#define MENU_GEAR_CANCEL        53
#define MENU_GEAR               54
#define MENU_INFO_CALCULATE     55
#define MENU_INFO_CANCEL        56
#define MENU_INFO               57
#define MENU_DERIV_CALCULATE    58
#define MENU_DERIV_CANCEL       59
#define MENU_DERIV              60
#define MENU_PWR_CALCULATE      61
#define MENU_PWR_CANCEL         62
#define MENU_PWR                63
#define MENU_ROTATE_X           64


typedef struct _view_info_t {
	struct          _view_info_t    *other_view;
	unsigned int    flags;
	Widget          other_widget;   /* the other view */
	Window          other_window;   /* XtWindow (other_widget) */
	Pixmap          pixmap;         /* A copy of this window's contents */
	GC              gc;
	GC              erase_gc;
	GC              grid_gc;
	short           origin_x, origin_y; /* view's origin screen location */
	int             layout;         /* axes that we're viewing */
	Dimension       width, height;
	}       view_info_t;

#define VI_PIXMAP_ALLOCATED     1

typedef struct {
	long    numerator, denominator;
	}       fraction_t;

typedef struct {
	fraction_t      x, y, z;
	}       loc_t;
	
typedef struct {
	loc_t location;         /* precise point location */
	VPoint  point;                  /* location as doubles */
	short   x, y, z;                /* pixel offset from origin */
	}       point_t;

typedef struct  _polygon_t {
	long    id;
	long    next;
	VPoint  normal;         /* normal vector of this polygon's plane */
	VPoint  origin;         /* plane's origin */
	double  d;              /* plane equation: a x + b y + c z + d = 0 */
	VPoint  trihedral;      /* used to transform from planar to world */
	int     num_points;     /* number of points defined */
	point_t *point;         /* an array of points */
	}       polygon_t;

typedef struct {
	Boolean defined;        /* is the marker defined yet? */
	int     id;             /* a unique identifier for each marker */
	char    name[32];       /* name of this marker */
	point_t location;       /* where is this marker located */
	}       marker_t;

EXTERN AppData          app_data;
EXTERN int              edit_state;
EXTERN polygon_t        *cur_polygon;
EXTERN int              sel_polygon;    /* list of selected polygons */
EXTERN int              unsel_polygon;  /* list of unselected polygons */
EXTERN int              clipboard_polygon;
EXTERN polygon_t        *polygon_list;  /* array of polygon pool */
EXTERN int              polygon_count, polygon_max;
EXTERN double           pixel_scale;    /* display scale (units per pixel) */
EXTERN long             ruler_divisions;
EXTERN point_t          *tmp_point;
EXTERN int              tmp_point_max;
EXTERN Widget           twindow;
EXTERN Widget           bwindow;
EXTERN Widget           open_dialog;
EXTERN Widget           save_as_dialog;
EXTERN Widget           save_formats[3];
EXTERN Widget           set_views_dialog;
EXTERN Widget           rescale_field;
EXTERN Widget           rescale_dialog;
EXTERN Widget           gear_dialog;
EXTERN Widget           info_dialog;
EXTERN Widget           deriv_dialog;
EXTERN Widget           powerplant_dialog;
EXTERN Widget           extent_x, extent_y, extent_z;
EXTERN Widget           x_field, y_field, z_field;
EXTERN XPoint           drag_origin;    /* where a drag operation started */
EXTERN Boolean          drag_mode;
EXTERN XSegment         rubber_lines[2];
EXTERN Cursor           cursors[6];
EXTERN Boolean          filename_valid;
EXTERN char             filename[256];
EXTERN int              desired_view;
EXTERN marker_t         *marker_list;
EXTERN int              current_marker;
EXTERN int              marker_count;
EXTERN Boolean          craft_valid;
EXTERN char             craft_name[128];


// A copy of the craft type structure from the acm/inventory.h file with only
// the fields here left.
typedef struct craftType {
	char     *name;             /* short name of aircraft class */
	double    Clda;             /* roll moment from aileron offset */
	double    Cldr;             /* roll moment from rudder offset */
	double    Clp;              /* roll damping */
	double    Cmq;              /* damping in pitch */
	double    Cnr;              /* damping in yaw */
	VMatrix   I;                /* Moments of Inertia about CG in AXYZ (lb ft^2) */
	double    cmSlope;          /* CmAlpha curve slope */
	double    wingS;            /* wing area (ft^2) */
	double    wings;            /* wing half-span (ft) */
	double    c;                /* mean aerodynamic chord (MAC) (ft) */
	double    emptyWeight;      /* empty mass (lb) */
	double    maxFuel;          /* maximum internal fuel (lb) */
	double    maxThrust;        /* max static thrust, military power (lbf) */
	double    maxABThrust;      /* max static thrust, afterburner on  (lbf) */
	double    engineLag;        /* controls lag between throttle and RPM */
	double    spFuelConsump;    /* specific fuel consump(lb fuel/lbf T x hr) */
	double    spABFuelConsump;
	VPoint    viewPoint;        /* pilot's viewing location wrt CG (ft) */
	VPoint    rm, rn;           /* location if main/nose gear attachments */
	double    Dm, Dn;           /* main/nose oleo damping factor */
	double    Km, Kn;           /* main/nose oleo spring factor */
	double    Gm, Gn;           /* main/nose strut length with tire */
	double    cmMax, cnMax;     /* main/nose maximum oleo extension distance */
} craftType;


EXTERN craftType        c;

/*
 *  edit_state values
 */

#define STATE_POINT             0
#define STATE_POLYGON           1
#define STATE_MOVE_ORIGIN       2
#define STATE_CIRCLE            3
#define STATE_MARKER            4

/*
 *  view layouts
 */

#define VL_XZ                   0
#define VL_XY                   1
#define VL_NXZ                  2
#define VL_NXY                  3
#define VL_NXNZ                 4
#define VL_NXNY                 5
#define VL_NYX                  6
#define VL_NYZ                  7
#define VL_NYNX                 8
#define VL_NYNZ                 9

/*
 *  Cursor definitions
 */

#define CURSOR_POINT            0
#define CURSOR_POLY_PLANE       1
#define CURSOR_POLY             2
#define CURSOR_ORIGIN           3
#define CURSOR_CIRCLE           4
#define CURSOR_MARKER           5

/*
 *  Valid view configurations
 */

#define VIEW_LEFT_TOP           0
#define VIEW_FRONT_TOP          1

/*
 *  Markers
 */

#define MARKER_HEAD             0
#define MARKER_NOSE_GEAR        1
#define MARKER_MAIN_GEAR        2
#define MARKER_TAIL_SCRAPE      3

/*
 * Nasty pointer to/from int conversions that prevent gcc -Wall complains
 * on both 32 and 64 bits systems. The code use them here and there where
 * Xt callbacks expects users' data be pointers instead.
 */
#define shared_PtrToInt(p)  ((int)((void *)(p) - (void *) 0))
#define shared_IntToPtr(i)  ((void *)((char *) 0 + i))

EXTERN view_info_t t_info, b_info;

EXTERN void SetCursor (int id);
EXTERN void MenuCB (Widget w, void *client_data, void *call_data);

#undef EXTERN
#endif
